/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.schema.NftTransferSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class NftTransferProtoCodec
implements Codec<NftTransfer> {
    @NonNull
    public NftTransfer parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NftTransfer parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NftTransfer data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)data.senderAccountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)data.receiverAccountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)data.serialNumber());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)data.isApproval());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NftTransfer data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)data.senderAccountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)data.receiverAccountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)data.serialNumber());
        return size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)data.isApproval());
    }

    public boolean fastEquals(@NonNull NftTransfer item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private NftTransfer parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        AccountID temp_senderAccountID = null;
        AccountID temp_receiverAccountID = null;
        long temp_serialNumber = 0L;
        boolean temp_is_approval = false;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = NftTransferSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        AccountID value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_senderAccountID = value;
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        AccountID value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_receiverAccountID = value;
                        continue block8;
                    }
                    case 24: {
                        long value;
                        temp_serialNumber = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 32: {
                        boolean value;
                        temp_is_approval = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new NftTransfer(temp_senderAccountID, temp_receiverAccountID, temp_serialNumber, temp_is_approval);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new NftTransfer(temp_senderAccountID, temp_receiverAccountID, temp_serialNumber, temp_is_approval);
    }
}

