/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NodeAddress;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NodeAddressJsonCodec
implements JsonCodec<NodeAddress> {
    @NonNull
    public NodeAddress parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        Bytes temp_ipAddress = Bytes.EMPTY;
        int temp_portno = 0;
        Bytes temp_memo = Bytes.EMPTY;
        String temp_RSA_PubKey = "";
        long temp_nodeId = 0L;
        AccountID temp_nodeAccountId = null;
        Bytes temp_nodeCertHash = Bytes.EMPTY;
        List temp_serviceEndpoint = Collections.emptyList();
        String temp_description = "";
        long temp_stake = 0L;
        block24: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "ipAddress": {
                    temp_ipAddress = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "portno": {
                    temp_portno = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "memo": {
                    temp_memo = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "RSAPubKey": {
                    temp_RSA_PubKey = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "nodeId": {
                    temp_nodeId = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "nodeAccountId": {
                    temp_nodeAccountId = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block24;
                }
                case "nodeCertHash": {
                    temp_nodeCertHash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "serviceEndpoint": {
                    temp_serviceEndpoint = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ServiceEndpoint.JSON);
                    continue block24;
                }
                case "description": {
                    temp_description = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "stake": {
                    temp_stake = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new NodeAddress(temp_ipAddress, temp_portno, temp_memo, temp_RSA_PubKey, temp_nodeId, temp_nodeAccountId, temp_nodeCertHash, temp_serviceEndpoint, temp_description, temp_stake);
    }

    public String toJSON(@NonNull NodeAddress data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.ipAddress() != Bytes.EMPTY && data.ipAddress() != null && data.ipAddress().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ipAddress", (Bytes)data.ipAddress()));
        }
        if (data.portno() != 0) {
            fieldLines.add(JsonTools.field((String)"portno", (int)data.portno()));
        }
        if (data.memo() != Bytes.EMPTY && data.memo() != null && data.memo().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"memo", (Bytes)data.memo()));
        }
        if (data.rsaPubKey() != "") {
            fieldLines.add(JsonTools.field((String)"RSAPubKey", (String)data.rsaPubKey()));
        }
        if (data.nodeId() != 0L) {
            fieldLines.add(JsonTools.field((String)"nodeId", (long)data.nodeId()));
        }
        if (data.nodeAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"nodeAccountId", AccountID.JSON, (Object)data.nodeAccountId()));
        }
        if (data.nodeCertHash() != Bytes.EMPTY && data.nodeCertHash() != null && data.nodeCertHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"nodeCertHash", (Bytes)data.nodeCertHash()));
        }
        if (!data.serviceEndpoint().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"serviceEndpoint", ServiceEndpoint.JSON, data.serviceEndpoint()));
        }
        if (data.description() != "") {
            fieldLines.add(JsonTools.field((String)"description", (String)data.description()));
        }
        if (data.stake() != 0L) {
            fieldLines.add(JsonTools.field((String)"stake", (long)data.stake()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

