/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.schema.QueryHeaderSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class QueryHeaderProtoCodec
implements Codec<QueryHeader> {
    @NonNull
    public QueryHeader parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public QueryHeader parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull QueryHeader data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)QueryHeaderSchema.PAYMENT, (Object)data.payment(), (arg_0, arg_1) -> Transaction.PROTOBUF.write(arg_0, arg_1), arg_0 -> Transaction.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)QueryHeaderSchema.RESPONSE_TYPE, (EnumWithProtoMetadata)data.responseType());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(QueryHeader data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)QueryHeaderSchema.PAYMENT, (Object)data.payment(), arg_0 -> Transaction.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfEnum((FieldDefinition)QueryHeaderSchema.RESPONSE_TYPE, (EnumWithProtoMetadata)data.responseType());
    }

    public boolean fastEquals(@NonNull QueryHeader item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private QueryHeader parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Transaction temp_payment = null;
        ResponseType temp_responseType = ResponseType.values()[0];
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = QueryHeaderSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Transaction value = strictMode ? (Transaction)Transaction.PROTOBUF.parseStrict(input) : (Transaction)Transaction.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_payment = value;
                        continue block6;
                    }
                    case 16: {
                        ResponseType value;
                        temp_responseType = value = ResponseType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new QueryHeader(temp_payment, temp_responseType);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new QueryHeader(temp_payment, temp_responseType);
    }
}

