/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.schema.ResponseHeaderSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ResponseHeaderProtoCodec
implements Codec<ResponseHeader> {
    @NonNull
    public ResponseHeader parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ResponseHeader parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ResponseHeader data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)ResponseHeaderSchema.NODE_TRANSACTION_PRECHECK_CODE, (EnumWithProtoMetadata)data.nodeTransactionPrecheckCode());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)ResponseHeaderSchema.RESPONSE_TYPE, (EnumWithProtoMetadata)data.responseType());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ResponseHeaderSchema.COST, (long)data.cost());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ResponseHeaderSchema.STATE_PROOF, (RandomAccessData)data.stateProof());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ResponseHeader data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ResponseHeaderSchema.NODE_TRANSACTION_PRECHECK_CODE, (EnumWithProtoMetadata)data.nodeTransactionPrecheckCode());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ResponseHeaderSchema.RESPONSE_TYPE, (EnumWithProtoMetadata)data.responseType());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ResponseHeaderSchema.COST, (long)data.cost());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ResponseHeaderSchema.STATE_PROOF, (RandomAccessData)data.stateProof());
    }

    public boolean fastEquals(@NonNull ResponseHeader item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ResponseHeader parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ResponseCodeEnum temp_nodeTransactionPrecheckCode = ResponseCodeEnum.values()[0];
        ResponseType temp_responseType = ResponseType.values()[0];
        long temp_cost = 0L;
        Bytes temp_stateProof = Bytes.EMPTY;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ResponseHeaderSchema.getField(field);
                switch (tag) {
                    case 8: {
                        ResponseCodeEnum value;
                        temp_nodeTransactionPrecheckCode = value = ResponseCodeEnum.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block8;
                    }
                    case 16: {
                        ResponseType value;
                        temp_responseType = value = ResponseType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block8;
                    }
                    case 24: {
                        long value;
                        temp_cost = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 34: {
                        Bytes value;
                        temp_stateProof = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ResponseHeader(temp_nodeTransactionPrecheckCode, temp_responseType, temp_cost, temp_stateProof);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ResponseHeader(temp_nodeTransactionPrecheckCode, temp_responseType, temp_cost, temp_stateProof);
    }
}

