/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.schema.ScheduleIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ScheduleIDProtoCodec
implements Codec<ScheduleID> {
    @NonNull
    public ScheduleID parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ScheduleID parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ScheduleID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ScheduleIDSchema.SHARD_NUM, (long)data.shardNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ScheduleIDSchema.REALM_NUM, (long)data.realmNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ScheduleIDSchema.SCHEDULE_NUM, (long)data.scheduleNum());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ScheduleID data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleIDSchema.SHARD_NUM, (long)data.shardNum());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleIDSchema.REALM_NUM, (long)data.realmNum());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleIDSchema.SCHEDULE_NUM, (long)data.scheduleNum());
    }

    public boolean fastEquals(@NonNull ScheduleID item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ScheduleID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_shardNum = 0L;
        long temp_realmNum = 0L;
        long temp_scheduleNum = 0L;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ScheduleIDSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_shardNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 16: {
                        long value;
                        temp_realmNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 24: {
                        long value;
                        temp_scheduleNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ScheduleID(temp_shardNum, temp_realmNum, temp_scheduleNum);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ScheduleID(temp_shardNum, temp_realmNum, temp_scheduleNum);
    }
}

