/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.schema.SemanticVersionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SemanticVersionProtoCodec
implements Codec<SemanticVersion> {
    @NonNull
    public SemanticVersion parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SemanticVersion parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SemanticVersion data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SemanticVersionSchema.MAJOR, (int)data.major());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SemanticVersionSchema.MINOR, (int)data.minor());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SemanticVersionSchema.PATCH, (int)data.patch());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)SemanticVersionSchema.PRE, (String)data.pre());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)SemanticVersionSchema.BUILD, (String)data.build());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SemanticVersion data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SemanticVersionSchema.MAJOR, (int)data.major());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SemanticVersionSchema.MINOR, (int)data.minor());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SemanticVersionSchema.PATCH, (int)data.patch());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)SemanticVersionSchema.PRE, (String)data.pre());
        return size += ProtoWriterTools.sizeOfString((FieldDefinition)SemanticVersionSchema.BUILD, (String)data.build());
    }

    public boolean fastEquals(@NonNull SemanticVersion item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SemanticVersion parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        int temp_major = 0;
        int temp_minor = 0;
        int temp_patch = 0;
        String temp_pre = "";
        String temp_build = "";
        try {
            block9: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SemanticVersionSchema.getField(field);
                switch (tag) {
                    case 8: {
                        int value;
                        temp_major = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 16: {
                        int value;
                        temp_minor = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 24: {
                        int value;
                        temp_patch = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 34: {
                        String value;
                        temp_pre = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 42: {
                        String value;
                        temp_build = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block9;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SemanticVersion(temp_major, temp_minor, temp_patch, temp_pre, temp_build);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SemanticVersion(temp_major, temp_minor, temp_patch, temp_pre, temp_build);
    }
}

