/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.base.schema.SignatureMapSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SignatureMapProtoCodec
implements Codec<SignatureMap> {
    @NonNull
    public SignatureMap parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SignatureMap parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SignatureMap data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)SignatureMapSchema.SIG_PAIR, data.sigPair(), (arg_0, arg_1) -> SignaturePair.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignaturePair.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SignatureMap data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)SignatureMapSchema.SIG_PAIR, data.sigPair(), arg_0 -> SignaturePair.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull SignatureMap item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SignatureMap parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        List temp_sigPair = Collections.emptyList();
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SignatureMapSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        SignaturePair value = strictMode ? (SignaturePair)SignaturePair.PROTOBUF.parseStrict(input) : (SignaturePair)SignaturePair.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sigPair = ProtoParserTools.addToList(temp_sigPair, (Object)value);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SignatureMap(temp_sigPair);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SignatureMap(temp_sigPair);
    }
}

