/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class TimestampJsonCodec
implements JsonCodec<Timestamp> {
    @NonNull
    public Timestamp parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        long temp_seconds = 0L;
        int temp_nanos = 0;
        block8: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "seconds": {
                    temp_seconds = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block8;
                }
                case "nanos": {
                    temp_nanos = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                    continue block8;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new Timestamp(temp_seconds, temp_nanos);
    }

    public String toJSON(@NonNull Timestamp data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.seconds() != 0L) {
            fieldLines.add(JsonTools.field((String)"seconds", (long)data.seconds()));
        }
        if (data.nanos() != 0) {
            fieldLines.add(JsonTools.field((String)"nanos", (int)data.nanos()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

