/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.schema.TokenIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TokenIDProtoCodec
implements Codec<TokenID> {
    @NonNull
    public TokenID parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TokenID parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TokenID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenIDSchema.SHARD_NUM, (long)data.shardNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenIDSchema.REALM_NUM, (long)data.realmNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenIDSchema.TOKEN_NUM, (long)data.tokenNum());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TokenID data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenIDSchema.SHARD_NUM, (long)data.shardNum());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenIDSchema.REALM_NUM, (long)data.realmNum());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenIDSchema.TOKEN_NUM, (long)data.tokenNum());
    }

    public boolean fastEquals(@NonNull TokenID item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TokenID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_shardNum = 0L;
        long temp_realmNum = 0L;
        long temp_tokenNum = 0L;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenIDSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_shardNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 16: {
                        long value;
                        temp_realmNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 24: {
                        long value;
                        temp_tokenNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TokenID(temp_shardNum, temp_realmNum, temp_tokenNum);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TokenID(temp_shardNum, temp_realmNum, temp_tokenNum);
    }
}

