/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.schema.TransactionIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TransactionIDProtoCodec
implements Codec<TransactionID> {
    @NonNull
    public TransactionID parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionID parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionIDSchema.TRANSACTION_VALID_START, (Object)data.transactionValidStart(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionIDSchema.ACCOUNT_ID, (Object)data.accountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TransactionIDSchema.SCHEDULED, (boolean)data.scheduled());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TransactionIDSchema.NONCE, (int)data.nonce());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionID data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionIDSchema.TRANSACTION_VALID_START, (Object)data.transactionValidStart(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionIDSchema.ACCOUNT_ID, (Object)data.accountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TransactionIDSchema.SCHEDULED, (boolean)data.scheduled());
        return size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TransactionIDSchema.NONCE, (int)data.nonce());
    }

    public boolean fastEquals(@NonNull TransactionID item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransactionID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_transactionValidStart = null;
        Record temp_accountID = null;
        int temp_scheduled = 0;
        int temp_nonce = 0;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionIDSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transactionValidStart = value;
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountID = value;
                        continue block8;
                    }
                    case 24: {
                        int value;
                        temp_scheduled = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 32: {
                        int value;
                        temp_nonce = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransactionID((Timestamp)temp_transactionValidStart, (AccountID)temp_accountID, temp_scheduled != 0, temp_nonce);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransactionID((Timestamp)temp_transactionValidStart, (AccountID)temp_accountID, temp_scheduled != 0, temp_nonce);
    }
}

