/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.consensus.codec.ConsensusCreateTopicTransactionBodyJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusCreateTopicTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusCreateTopicTransactionBody(String memo, @Nullable Key adminKey, @Nullable Key submitKey, @Nullable Duration autoRenewPeriod, @Nullable AccountID autoRenewAccount) {
    public static final Codec<ConsensusCreateTopicTransactionBody> PROTOBUF = new ConsensusCreateTopicTransactionBodyProtoCodec();
    public static final JsonCodec<ConsensusCreateTopicTransactionBody> JSON = new ConsensusCreateTopicTransactionBodyJsonCodec();
    public static final ConsensusCreateTopicTransactionBody DEFAULT = ConsensusCreateTopicTransactionBody.newBuilder().build();

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.memo, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String memo = "";
        private Key adminKey = null;
        private Key submitKey = null;
        private Duration autoRenewPeriod = null;
        private AccountID autoRenewAccount = null;

        public Builder() {
        }

        public Builder(String memo, Key adminKey, Key submitKey, Duration autoRenewPeriod, AccountID autoRenewAccount) {
            this.memo = memo;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccount = autoRenewAccount;
        }

        public ConsensusCreateTopicTransactionBody build() {
            return new ConsensusCreateTopicTransactionBody(this.memo, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder autoRenewAccount(AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }
    }
}

