/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.consensus.ConsensusMessageChunkInfo;
import com.hedera.hapi.node.consensus.codec.ConsensusSubmitMessageTransactionBodyJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusSubmitMessageTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusSubmitMessageTransactionBody(@Nullable TopicID topicID, Bytes message, @Nullable ConsensusMessageChunkInfo chunkInfo) {
    public static final Codec<ConsensusSubmitMessageTransactionBody> PROTOBUF = new ConsensusSubmitMessageTransactionBodyProtoCodec();
    public static final JsonCodec<ConsensusSubmitMessageTransactionBody> JSON = new ConsensusSubmitMessageTransactionBodyJsonCodec();
    public static final ConsensusSubmitMessageTransactionBody DEFAULT = ConsensusSubmitMessageTransactionBody.newBuilder().build();

    public boolean hasTopicID() {
        return this.topicID != null;
    }

    public TopicID topicIDOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicID() ? this.topicID : defaultValue;
    }

    @NonNull
    public TopicID topicIDOrThrow() {
        return Objects.requireNonNull(this.topicID, "Field topicID is null");
    }

    public void ifTopicID(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicID()) {
            ifPresent.accept(this.topicID);
        }
    }

    public boolean hasChunkInfo() {
        return this.chunkInfo != null;
    }

    public ConsensusMessageChunkInfo chunkInfoOrElse(@NonNull ConsensusMessageChunkInfo defaultValue) {
        return this.hasChunkInfo() ? this.chunkInfo : defaultValue;
    }

    @NonNull
    public ConsensusMessageChunkInfo chunkInfoOrThrow() {
        return Objects.requireNonNull(this.chunkInfo, "Field chunkInfo is null");
    }

    public void ifChunkInfo(@NonNull Consumer<ConsensusMessageChunkInfo> ifPresent) {
        if (this.hasChunkInfo()) {
            ifPresent.accept(this.chunkInfo);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.topicID, this.message, this.chunkInfo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TopicID topicID = null;
        private Bytes message = Bytes.EMPTY;
        private ConsensusMessageChunkInfo chunkInfo = null;

        public Builder() {
        }

        public Builder(TopicID topicID, Bytes message, ConsensusMessageChunkInfo chunkInfo) {
            this.topicID = topicID;
            this.message = message;
            this.chunkInfo = chunkInfo;
        }

        public ConsensusSubmitMessageTransactionBody build() {
            return new ConsensusSubmitMessageTransactionBody(this.topicID, this.message, this.chunkInfo);
        }

        public Builder topicID(TopicID topicID) {
            this.topicID = topicID;
            return this;
        }

        public Builder topicID(TopicID.Builder builder) {
            this.topicID = builder.build();
            return this;
        }

        public Builder message(Bytes message) {
            this.message = message;
            return this;
        }

        public Builder chunkInfo(ConsensusMessageChunkInfo chunkInfo) {
            this.chunkInfo = chunkInfo;
            return this;
        }

        public Builder chunkInfo(ConsensusMessageChunkInfo.Builder builder) {
            this.chunkInfo = builder.build();
            return this;
        }
    }
}

