/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus.codec;

import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.consensus.ConsensusMessageChunkInfo;
import com.hedera.hapi.node.consensus.schema.ConsensusMessageChunkInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ConsensusMessageChunkInfoProtoCodec
implements Codec<ConsensusMessageChunkInfo> {
    @NonNull
    public ConsensusMessageChunkInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ConsensusMessageChunkInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ConsensusMessageChunkInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ConsensusMessageChunkInfoSchema.INITIAL_TRANSACTION_ID, (Object)data.initialTransactionID(), (arg_0, arg_1) -> TransactionID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ConsensusMessageChunkInfoSchema.TOTAL, (int)data.total());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ConsensusMessageChunkInfoSchema.NUMBER, (int)data.number());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ConsensusMessageChunkInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ConsensusMessageChunkInfoSchema.INITIAL_TRANSACTION_ID, (Object)data.initialTransactionID(), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ConsensusMessageChunkInfoSchema.TOTAL, (int)data.total());
        return size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ConsensusMessageChunkInfoSchema.NUMBER, (int)data.number());
    }

    public boolean fastEquals(@NonNull ConsensusMessageChunkInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ConsensusMessageChunkInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        TransactionID temp_initialTransactionID = null;
        int temp_total = 0;
        int temp_number = 0;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ConsensusMessageChunkInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        TransactionID value = strictMode ? (TransactionID)TransactionID.PROTOBUF.parseStrict(input) : (TransactionID)TransactionID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_initialTransactionID = value;
                        continue block7;
                    }
                    case 16: {
                        int value;
                        temp_total = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 24: {
                        int value;
                        temp_number = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ConsensusMessageChunkInfo(temp_initialTransactionID, temp_total, temp_number);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ConsensusMessageChunkInfo(temp_initialTransactionID, temp_total, temp_number);
    }
}

