/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractCallTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractCallTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractCallTransactionBody(@Nullable ContractID contractID, long gas, long amount, Bytes functionParameters) {
    public static final Codec<ContractCallTransactionBody> PROTOBUF = new ContractCallTransactionBodyProtoCodec();
    public static final JsonCodec<ContractCallTransactionBody> JSON = new ContractCallTransactionBodyJsonCodec();
    public static final ContractCallTransactionBody DEFAULT = ContractCallTransactionBody.newBuilder().build();

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.gas, this.amount, this.functionParameters);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ContractID contractID = null;
        private long gas = 0L;
        private long amount = 0L;
        private Bytes functionParameters = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(ContractID contractID, long gas, long amount, Bytes functionParameters) {
            this.contractID = contractID;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters;
        }

        public ContractCallTransactionBody build() {
            return new ContractCallTransactionBody(this.contractID, this.gas, this.amount, this.functionParameters);
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder functionParameters(Bytes functionParameters) {
            this.functionParameters = functionParameters;
            return this;
        }
    }
}

