/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractLoginfoJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractLoginfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractLoginfo(@Nullable ContractID contractID, Bytes bloom, List<Bytes> topic, Bytes data) {
    public static final Codec<ContractLoginfo> PROTOBUF = new ContractLoginfoProtoCodec();
    public static final JsonCodec<ContractLoginfo> JSON = new ContractLoginfoJsonCodec();
    public static final ContractLoginfo DEFAULT = ContractLoginfo.newBuilder().build();

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.bloom, this.topic, this.data);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ContractID contractID = null;
        private Bytes bloom = Bytes.EMPTY;
        private List<Bytes> topic = Collections.emptyList();
        private Bytes data = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(ContractID contractID, Bytes bloom, List<Bytes> topic, Bytes data) {
            this.contractID = contractID;
            this.bloom = bloom;
            this.topic = topic;
            this.data = data;
        }

        public ContractLoginfo build() {
            return new ContractLoginfo(this.contractID, this.bloom, this.topic, this.data);
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder bloom(Bytes bloom) {
            this.bloom = bloom;
            return this;
        }

        public Builder topic(List<Bytes> topic) {
            this.topic = topic;
            return this;
        }

        public Builder topic(Bytes ... values) {
            this.topic = List.of(values);
            return this;
        }

        public Builder data(Bytes data) {
            this.data = data;
            return this;
        }
    }
}

