/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record EthereumTransactionBody(Bytes ethereumData, @Nullable FileID callData, long maxGasAllowance) {
    public static final Codec<EthereumTransactionBody> PROTOBUF = new EthereumTransactionBodyProtoCodec();
    public static final JsonCodec<EthereumTransactionBody> JSON = new EthereumTransactionBodyJsonCodec();
    public static final EthereumTransactionBody DEFAULT = EthereumTransactionBody.newBuilder().build();

    public boolean hasCallData() {
        return this.callData != null;
    }

    public FileID callDataOrElse(@NonNull FileID defaultValue) {
        return this.hasCallData() ? this.callData : defaultValue;
    }

    @NonNull
    public FileID callDataOrThrow() {
        return Objects.requireNonNull(this.callData, "Field callData is null");
    }

    public void ifCallData(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasCallData()) {
            ifPresent.accept(this.callData);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ethereumData, this.callData, this.maxGasAllowance);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Bytes ethereumData = Bytes.EMPTY;
        private FileID callData = null;
        private long maxGasAllowance = 0L;

        public Builder() {
        }

        public Builder(Bytes ethereumData, FileID callData, long maxGasAllowance) {
            this.ethereumData = ethereumData;
            this.callData = callData;
            this.maxGasAllowance = maxGasAllowance;
        }

        public EthereumTransactionBody build() {
            return new EthereumTransactionBody(this.ethereumData, this.callData, this.maxGasAllowance);
        }

        public Builder ethereumData(Bytes ethereumData) {
            this.ethereumData = ethereumData;
            return this;
        }

        public Builder callData(FileID callData) {
            this.callData = callData;
            return this;
        }

        public Builder callData(FileID.Builder builder) {
            this.callData = builder.build();
            return this;
        }

        public Builder maxGasAllowance(long maxGasAllowance) {
            this.maxGasAllowance = maxGasAllowance;
            return this;
        }
    }
}

