/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.contract.ContractCallLocalQuery;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class ContractCallLocalQueryJsonCodec
implements JsonCodec<ContractCallLocalQuery> {
    @NonNull
    public ContractCallLocalQuery parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        QueryHeader temp_header = null;
        ContractID temp_contractID = null;
        long temp_gas = 0L;
        Bytes temp_functionParameters = Bytes.EMPTY;
        long temp_maxResultSize = 0L;
        AccountID temp_sender_id = null;
        block16: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "header": {
                    temp_header = (QueryHeader)QueryHeader.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block16;
                }
                case "contractID": {
                    temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block16;
                }
                case "gas": {
                    temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block16;
                }
                case "functionParameters": {
                    temp_functionParameters = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block16;
                }
                case "maxResultSize": {
                    temp_maxResultSize = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block16;
                }
                case "senderId": {
                    temp_sender_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block16;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new ContractCallLocalQuery(temp_header, temp_contractID, temp_gas, temp_functionParameters, temp_maxResultSize, temp_sender_id);
    }

    public String toJSON(@NonNull ContractCallLocalQuery data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.header() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"header", QueryHeader.JSON, (Object)data.header()));
        }
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.functionParameters() != Bytes.EMPTY && data.functionParameters() != null && data.functionParameters().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"functionParameters", (Bytes)data.functionParameters()));
        }
        if (data.maxResultSize() != 0L) {
            fieldLines.add(JsonTools.field((String)"maxResultSize", (long)data.maxResultSize()));
        }
        if (data.senderId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"senderId", AccountID.JSON, (Object)data.senderId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

