/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.contract.schema.ContractCallTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ContractCallTransactionBodyProtoCodec
implements Codec<ContractCallTransactionBody> {
    @NonNull
    public ContractCallTransactionBody parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractCallTransactionBody parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractCallTransactionBody data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractCallTransactionBodySchema.CONTRACT_ID, (Object)data.contractID(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractCallTransactionBodySchema.GAS, (long)data.gas());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractCallTransactionBodySchema.AMOUNT, (long)data.amount());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractCallTransactionBodySchema.FUNCTION_PARAMETERS, (RandomAccessData)data.functionParameters());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractCallTransactionBody data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractCallTransactionBodySchema.CONTRACT_ID, (Object)data.contractID(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractCallTransactionBodySchema.GAS, (long)data.gas());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractCallTransactionBodySchema.AMOUNT, (long)data.amount());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractCallTransactionBodySchema.FUNCTION_PARAMETERS, (RandomAccessData)data.functionParameters());
    }

    public boolean fastEquals(@NonNull ContractCallTransactionBody item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractCallTransactionBody parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ContractID temp_contractID = null;
        long temp_gas = 0L;
        long temp_amount = 0L;
        Bytes temp_functionParameters = Bytes.EMPTY;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractCallTransactionBodySchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ContractID value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contractID = value;
                        continue block8;
                    }
                    case 16: {
                        long value;
                        temp_gas = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 24: {
                        long value;
                        temp_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 34: {
                        Bytes value;
                        temp_functionParameters = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractCallTransactionBody(temp_contractID, temp_gas, temp_amount, temp_functionParameters);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractCallTransactionBody(temp_contractID, temp_gas, temp_amount, temp_functionParameters);
    }
}

