/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractFunctionResultJsonCodec
implements JsonCodec<ContractFunctionResult> {
    @NonNull
    public ContractFunctionResult parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        ContractID temp_contractID = null;
        Bytes temp_contractCallResult = Bytes.EMPTY;
        String temp_errorMessage = "";
        Bytes temp_bloom = Bytes.EMPTY;
        long temp_gasUsed = 0L;
        List temp_logInfo = Collections.emptyList();
        List temp_createdContractIDs = Collections.emptyList();
        Bytes temp_evm_address = null;
        long temp_gas = 0L;
        long temp_amount = 0L;
        Bytes temp_functionParameters = Bytes.EMPTY;
        AccountID temp_sender_id = null;
        List temp_contract_nonces = Collections.emptyList();
        block30: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "contractID": {
                    temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block30;
                }
                case "contractCallResult": {
                    temp_contractCallResult = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block30;
                }
                case "errorMessage": {
                    temp_errorMessage = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block30;
                }
                case "bloom": {
                    temp_bloom = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block30;
                }
                case "gasUsed": {
                    temp_gasUsed = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block30;
                }
                case "logInfo": {
                    temp_logInfo = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractLoginfo.JSON);
                    continue block30;
                }
                case "createdContractIDs": {
                    temp_createdContractIDs = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractID.JSON);
                    continue block30;
                }
                case "evmAddress": {
                    temp_evm_address = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block30;
                }
                case "gas": {
                    temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block30;
                }
                case "amount": {
                    temp_amount = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block30;
                }
                case "functionParameters": {
                    temp_functionParameters = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block30;
                }
                case "senderId": {
                    temp_sender_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block30;
                }
                case "contractNonces": {
                    temp_contract_nonces = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ContractNonceInfo.JSON);
                    continue block30;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new ContractFunctionResult(temp_contractID, temp_contractCallResult, temp_errorMessage, temp_bloom, temp_gasUsed, temp_logInfo, temp_createdContractIDs, temp_evm_address, temp_gas, temp_amount, temp_functionParameters, temp_sender_id, temp_contract_nonces);
    }

    public String toJSON(@NonNull ContractFunctionResult data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.contractCallResult() != Bytes.EMPTY && data.contractCallResult() != null && data.contractCallResult().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"contractCallResult", (Bytes)data.contractCallResult()));
        }
        if (data.errorMessage() != "") {
            fieldLines.add(JsonTools.field((String)"errorMessage", (String)data.errorMessage()));
        }
        if (data.bloom() != Bytes.EMPTY && data.bloom() != null && data.bloom().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"bloom", (Bytes)data.bloom()));
        }
        if (data.gasUsed() != 0L) {
            fieldLines.add(JsonTools.field((String)"gasUsed", (long)data.gasUsed()));
        }
        if (!data.logInfo().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"logInfo", ContractLoginfo.JSON, data.logInfo()));
        }
        if (!data.createdContractIDs().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"createdContractIDs", ContractID.JSON, data.createdContractIDs()));
        }
        if (data.evmAddress() != null) {
            fieldLines.add(JsonTools.field((String)"evmAddress", (Bytes)data.evmAddress()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.amount() != 0L) {
            fieldLines.add(JsonTools.field((String)"amount", (long)data.amount()));
        }
        if (data.functionParameters() != Bytes.EMPTY && data.functionParameters() != null && data.functionParameters().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"functionParameters", (Bytes)data.functionParameters()));
        }
        if (data.senderId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"senderId", AccountID.JSON, (Object)data.senderId()));
        }
        if (!data.contractNonces().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"contractNonces", ContractNonceInfo.JSON, data.contractNonces()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

