/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.schema.ContractFunctionResultSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ContractFunctionResultProtoCodec
implements Codec<ContractFunctionResult> {
    @NonNull
    public ContractFunctionResult parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractFunctionResult parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractFunctionResult data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.CONTRACT_ID, (Object)data.contractID(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.CONTRACT_CALL_RESULT, (RandomAccessData)data.contractCallResult());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.ERROR_MESSAGE, (String)data.errorMessage());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.BLOOM, (RandomAccessData)data.bloom());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.GAS_USED, (long)data.gasUsed());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.LOG_INFO, data.logInfo(), (arg_0, arg_1) -> ContractLoginfo.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractLoginfo.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.CREATED_CONTRACT_IDS, data.createdContractIDs(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeOptionalBytes((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.EVM_ADDRESS, (Bytes)data.evmAddress());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.GAS, (long)data.gas());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.AMOUNT, (long)data.amount());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.FUNCTION_PARAMETERS, (RandomAccessData)data.functionParameters());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.SENDER_ID, (Object)data.senderId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ContractFunctionResultSchema.CONTRACT_NONCES, data.contractNonces(), (arg_0, arg_1) -> ContractNonceInfo.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractNonceInfo.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractFunctionResult data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractFunctionResultSchema.CONTRACT_ID, (Object)data.contractID(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.CONTRACT_CALL_RESULT, (RandomAccessData)data.contractCallResult());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ContractFunctionResultSchema.ERROR_MESSAGE, (String)data.errorMessage());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.BLOOM, (RandomAccessData)data.bloom());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.GAS_USED, (long)data.gasUsed());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.LOG_INFO, data.logInfo(), arg_0 -> ContractLoginfo.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.CREATED_CONTRACT_IDS, data.createdContractIDs(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfOptionalBytes((FieldDefinition)ContractFunctionResultSchema.EVM_ADDRESS, (RandomAccessData)data.evmAddress());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.GAS, (long)data.gas());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.AMOUNT, (long)data.amount());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.FUNCTION_PARAMETERS, (RandomAccessData)data.functionParameters());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractFunctionResultSchema.SENDER_ID, (Object)data.senderId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.CONTRACT_NONCES, data.contractNonces(), arg_0 -> ContractNonceInfo.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ContractFunctionResult item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractFunctionResult parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_contractID = null;
        Bytes temp_contractCallResult = Bytes.EMPTY;
        String temp_errorMessage = "";
        Bytes temp_bloom = Bytes.EMPTY;
        long temp_gasUsed = 0L;
        List temp_logInfo = Collections.emptyList();
        List temp_createdContractIDs = Collections.emptyList();
        Bytes temp_evm_address = null;
        long temp_gas = 0L;
        long temp_amount = 0L;
        Bytes temp_functionParameters = Bytes.EMPTY;
        Record temp_sender_id = null;
        List temp_contract_nonces = Collections.emptyList();
        try {
            block17: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractFunctionResultSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contractID = value;
                        continue block17;
                    }
                    case 18: {
                        Bytes value;
                        temp_contractCallResult = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 26: {
                        String value;
                        temp_errorMessage = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 34: {
                        Bytes value;
                        temp_bloom = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 40: {
                        long value;
                        temp_gasUsed = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractLoginfo)ContractLoginfo.PROTOBUF.parseStrict(input) : (ContractLoginfo)ContractLoginfo.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_logInfo = ProtoParserTools.addToList(temp_logInfo, (Object)value);
                        continue block17;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_createdContractIDs = ProtoParserTools.addToList(temp_createdContractIDs, (Object)value);
                        continue block17;
                    }
                    case 74: {
                        Bytes value;
                        int valueTypeMessageSize = input.readVarInt(false);
                        if (valueTypeMessageSize > 0) {
                            long beforeLimit = input.limit();
                            input.limit(input.position() + (long)valueTypeMessageSize);
                            int valueFieldTag = input.readVarInt(false);
                            assert (valueFieldTag >>> 3 == 1);
                            assert ((valueFieldTag & 7) == 2);
                            value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                            input.limit(beforeLimit);
                        } else {
                            value = Bytes.EMPTY;
                        }
                        temp_evm_address = value;
                        continue block17;
                    }
                    case 80: {
                        long value;
                        temp_gas = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 88: {
                        long value;
                        temp_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 98: {
                        Bytes value;
                        temp_functionParameters = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sender_id = value;
                        continue block17;
                    }
                    case 114: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractNonceInfo)ContractNonceInfo.PROTOBUF.parseStrict(input) : (ContractNonceInfo)ContractNonceInfo.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contract_nonces = ProtoParserTools.addToList(temp_contract_nonces, (Object)value);
                        continue block17;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractFunctionResult((ContractID)temp_contractID, temp_contractCallResult, temp_errorMessage, temp_bloom, temp_gasUsed, temp_logInfo, temp_createdContractIDs, temp_evm_address, temp_gas, temp_amount, temp_functionParameters, (AccountID)temp_sender_id, temp_contract_nonces);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractFunctionResult((ContractID)temp_contractID, temp_contractCallResult, temp_errorMessage, temp_bloom, temp_gasUsed, temp_logInfo, temp_createdContractIDs, temp_evm_address, temp_gas, temp_amount, temp_functionParameters, (AccountID)temp_sender_id, temp_contract_nonces);
    }
}

