/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.contract.ContractInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractInfoJsonCodec
implements JsonCodec<ContractInfo> {
    @NonNull
    public ContractInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        ContractID temp_contractID = null;
        AccountID temp_accountID = null;
        String temp_contractAccountID = "";
        Key temp_adminKey = null;
        Timestamp temp_expirationTime = null;
        Duration temp_autoRenewPeriod = null;
        long temp_storage = 0L;
        String temp_memo = "";
        long temp_balance = 0L;
        boolean temp_deleted = false;
        List temp_tokenRelationships = Collections.emptyList();
        Bytes temp_ledger_id = Bytes.EMPTY;
        AccountID temp_auto_renew_account_id = null;
        int temp_max_automatic_token_associations = 0;
        StakingInfo temp_staking_info = null;
        block34: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "contractID": {
                    temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "accountID": {
                    temp_accountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "contractAccountID": {
                    temp_contractAccountID = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block34;
                }
                case "adminKey": {
                    temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "expirationTime": {
                    temp_expirationTime = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "autoRenewPeriod": {
                    temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "storage": {
                    temp_storage = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block34;
                }
                case "memo": {
                    temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block34;
                }
                case "balance": {
                    temp_balance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block34;
                }
                case "deleted": {
                    temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                    continue block34;
                }
                case "tokenRelationships": {
                    temp_tokenRelationships = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenRelationship.JSON);
                    continue block34;
                }
                case "ledgerId": {
                    temp_ledger_id = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block34;
                }
                case "autoRenewAccountId": {
                    temp_auto_renew_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
                case "maxAutomaticTokenAssociations": {
                    temp_max_automatic_token_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                    continue block34;
                }
                case "stakingInfo": {
                    temp_staking_info = (StakingInfo)StakingInfo.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block34;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new ContractInfo(temp_contractID, temp_accountID, temp_contractAccountID, temp_adminKey, temp_expirationTime, temp_autoRenewPeriod, temp_storage, temp_memo, temp_balance, temp_deleted, temp_tokenRelationships, temp_ledger_id, temp_auto_renew_account_id, temp_max_automatic_token_associations, temp_staking_info);
    }

    public String toJSON(@NonNull ContractInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.accountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountID", AccountID.JSON, (Object)data.accountID()));
        }
        if (data.contractAccountID() != "") {
            fieldLines.add(JsonTools.field((String)"contractAccountID", (String)data.contractAccountID()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.expirationTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expirationTime", Timestamp.JSON, (Object)data.expirationTime()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (data.storage() != 0L) {
            fieldLines.add(JsonTools.field((String)"storage", (long)data.storage()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.balance() != 0L) {
            fieldLines.add(JsonTools.field((String)"balance", (long)data.balance()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (!data.tokenRelationships().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenRelationships", TokenRelationship.JSON, data.tokenRelationships()));
        }
        if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
        }
        if (data.autoRenewAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccountId", AccountID.JSON, (Object)data.autoRenewAccountId()));
        }
        if (data.maxAutomaticTokenAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"maxAutomaticTokenAssociations", (int)data.maxAutomaticTokenAssociations()));
        }
        if (data.stakingInfo() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"stakingInfo", StakingInfo.JSON, (Object)data.stakingInfo()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

