/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.contract.ContractInfo;
import com.hedera.hapi.node.contract.schema.ContractInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ContractInfoProtoCodec
implements Codec<ContractInfo> {
    @NonNull
    public ContractInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.CONTRACT_ID, (Object)data.contractID(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.ACCOUNT_ID, (Object)data.accountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.CONTRACT_ACCOUNT_ID, (String)data.contractAccountID());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.STORAGE, (long)data.storage());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.BALANCE, (long)data.balance());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.TOKEN_RELATIONSHIPS, data.tokenRelationships(), (arg_0, arg_1) -> TokenRelationship.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenRelationship.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.MAX_AUTOMATIC_TOKEN_ASSOCIATIONS, (int)data.maxAutomaticTokenAssociations());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractInfoSchema.STAKING_INFO, (Object)data.stakingInfo(), (arg_0, arg_1) -> StakingInfo.PROTOBUF.write(arg_0, arg_1), arg_0 -> StakingInfo.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.CONTRACT_ID, (Object)data.contractID(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.ACCOUNT_ID, (Object)data.accountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ContractInfoSchema.CONTRACT_ACCOUNT_ID, (String)data.contractAccountID());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractInfoSchema.STORAGE, (long)data.storage());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ContractInfoSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractInfoSchema.BALANCE, (long)data.balance());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ContractInfoSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractInfoSchema.TOKEN_RELATIONSHIPS, data.tokenRelationships(), arg_0 -> TokenRelationship.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ContractInfoSchema.MAX_AUTOMATIC_TOKEN_ASSOCIATIONS, (int)data.maxAutomaticTokenAssociations());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractInfoSchema.STAKING_INFO, (Object)data.stakingInfo(), arg_0 -> StakingInfo.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ContractInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_contractID = null;
        Record temp_accountID = null;
        String temp_contractAccountID = "";
        Record temp_adminKey = null;
        Record temp_expirationTime = null;
        Record temp_autoRenewPeriod = null;
        long temp_storage = 0L;
        String temp_memo = "";
        long temp_balance = 0L;
        boolean temp_deleted = false;
        List temp_tokenRelationships = Collections.emptyList();
        Bytes temp_ledger_id = Bytes.EMPTY;
        Record temp_auto_renew_account_id = null;
        int temp_max_automatic_token_associations = 0;
        Record temp_staking_info = null;
        try {
            block19: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contractID = value;
                        continue block19;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountID = value;
                        continue block19;
                    }
                    case 26: {
                        String value;
                        temp_contractAccountID = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_adminKey = value;
                        continue block19;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expirationTime = value;
                        continue block19;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewPeriod = value;
                        continue block19;
                    }
                    case 56: {
                        long value;
                        temp_storage = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 66: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 72: {
                        long value;
                        temp_balance = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 80: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 90: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenRelationship)TokenRelationship.PROTOBUF.parseStrict(input) : (TokenRelationship)TokenRelationship.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenRelationships = ProtoParserTools.addToList(temp_tokenRelationships, (Object)value);
                        continue block19;
                    }
                    case 98: {
                        Bytes value;
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_auto_renew_account_id = value;
                        continue block19;
                    }
                    case 112: {
                        int value;
                        temp_max_automatic_token_associations = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (StakingInfo)StakingInfo.PROTOBUF.parseStrict(input) : (StakingInfo)StakingInfo.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_staking_info = value;
                        continue block19;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractInfo((ContractID)temp_contractID, (AccountID)temp_accountID, temp_contractAccountID, (Key)temp_adminKey, (Timestamp)temp_expirationTime, (Duration)temp_autoRenewPeriod, temp_storage, temp_memo, temp_balance, temp_deleted, temp_tokenRelationships, temp_ledger_id, (AccountID)temp_auto_renew_account_id, temp_max_automatic_token_associations, (StakingInfo)temp_staking_info);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractInfo((ContractID)temp_contractID, (AccountID)temp_accountID, temp_contractAccountID, (Key)temp_adminKey, (Timestamp)temp_expirationTime, (Duration)temp_autoRenewPeriod, temp_storage, temp_memo, temp_balance, temp_deleted, temp_tokenRelationships, temp_ledger_id, (AccountID)temp_auto_renew_account_id, temp_max_automatic_token_associations, (StakingInfo)temp_staking_info);
    }
}

