/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.file.codec.FileContentsJsonCodec;
import com.hedera.hapi.node.file.codec.FileContentsProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileContents(@Nullable FileID fileID, Bytes contents) {
    public static final Codec<FileContents> PROTOBUF = new FileContentsProtoCodec();
    public static final JsonCodec<FileContents> JSON = new FileContentsJsonCodec();
    public static final FileContents DEFAULT = FileContents.newBuilder().build();

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.contents);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private FileID fileID = null;
        private Bytes contents = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(FileID fileID, Bytes contents) {
            this.fileID = fileID;
            this.contents = contents;
        }

        public FileContents build() {
            return new FileContents(this.fileID, this.contents);
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder contents(Bytes contents) {
            this.contents = contents;
            return this;
        }
    }
}

