/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.FileInfo;
import com.hedera.hapi.node.file.schema.FileInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FileInfoProtoCodec
implements Codec<FileInfo> {
    @NonNull
    public FileInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FileInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FileInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.FILE_ID, (Object)data.fileID(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.SIZE, (long)data.size());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FileInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.FILE_ID, (Object)data.fileID(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileInfoSchema.SIZE, (long)data.size());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FileInfoSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)FileInfoSchema.MEMO, (String)data.memo());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public boolean fastEquals(@NonNull FileInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FileInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_fileID = null;
        long temp_size = 0L;
        Record temp_expirationTime = null;
        boolean temp_deleted = false;
        Record temp_keys = null;
        String temp_memo = "";
        Bytes temp_ledger_id = Bytes.EMPTY;
        try {
            block11: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FileInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fileID = value;
                        continue block11;
                    }
                    case 16: {
                        long value;
                        temp_size = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expirationTime = value;
                        continue block11;
                    }
                    case 32: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_keys = value;
                        continue block11;
                    }
                    case 50: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 58: {
                        Bytes value;
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block11;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new FileInfo((FileID)temp_fileID, temp_size, (Timestamp)temp_expirationTime, temp_deleted, (KeyList)temp_keys, temp_memo, temp_ledger_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new FileInfo((FileID)temp_fileID, temp_size, (Timestamp)temp_expirationTime, temp_deleted, (KeyList)temp_keys, temp_memo, temp_ledger_id);
    }
}

