/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockrecords;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoJsonCodec;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record BlockInfo(long lastBlockNumber, @Nullable Timestamp firstConsTimeOfLastBlock, Bytes blockHashes) {
    public static final Codec<BlockInfo> PROTOBUF = new BlockInfoProtoCodec();
    public static final JsonCodec<BlockInfo> JSON = new BlockInfoJsonCodec();
    public static final BlockInfo DEFAULT = BlockInfo.newBuilder().build();

    public boolean hasFirstConsTimeOfLastBlock() {
        return this.firstConsTimeOfLastBlock != null;
    }

    public Timestamp firstConsTimeOfLastBlockOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFirstConsTimeOfLastBlock() ? this.firstConsTimeOfLastBlock : defaultValue;
    }

    @NonNull
    public Timestamp firstConsTimeOfLastBlockOrThrow() {
        return Objects.requireNonNull(this.firstConsTimeOfLastBlock, "Field firstConsTimeOfLastBlock is null");
    }

    public void ifFirstConsTimeOfLastBlock(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFirstConsTimeOfLastBlock()) {
            ifPresent.accept(this.firstConsTimeOfLastBlock);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long lastBlockNumber = 0L;
        private Timestamp firstConsTimeOfLastBlock = null;
        private Bytes blockHashes = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes) {
            this.lastBlockNumber = lastBlockNumber;
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            this.blockHashes = blockHashes;
        }

        public BlockInfo build() {
            return new BlockInfo(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes);
        }

        public Builder lastBlockNumber(long lastBlockNumber) {
            this.lastBlockNumber = lastBlockNumber;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(Timestamp firstConsTimeOfLastBlock) {
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(Timestamp.Builder builder) {
            this.firstConsTimeOfLastBlock = builder.build();
            return this;
        }

        public Builder blockHashes(Bytes blockHashes) {
            this.blockHashes = blockHashes;
            return this;
        }
    }
}

