/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockrecords.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.schema.BlockInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class BlockInfoProtoCodec
implements Codec<BlockInfo> {
    @NonNull
    public BlockInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public BlockInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull BlockInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)BlockInfoSchema.LAST_BLOCK_NUMBER, (long)data.lastBlockNumber());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)BlockInfoSchema.FIRST_CONS_TIME_OF_LAST_BLOCK, (Object)data.firstConsTimeOfLastBlock(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)BlockInfoSchema.BLOCK_HASHES, (RandomAccessData)data.blockHashes());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(BlockInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockInfoSchema.LAST_BLOCK_NUMBER, (long)data.lastBlockNumber());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockInfoSchema.FIRST_CONS_TIME_OF_LAST_BLOCK, (Object)data.firstConsTimeOfLastBlock(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockInfoSchema.BLOCK_HASHES, (RandomAccessData)data.blockHashes());
    }

    public boolean fastEquals(@NonNull BlockInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private BlockInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_last_block_number = 0L;
        Timestamp temp_first_cons_time_of_last_block = null;
        Bytes temp_block_hashes = Bytes.EMPTY;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = BlockInfoSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_last_block_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Timestamp value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_first_cons_time_of_last_block = value;
                        continue block7;
                    }
                    case 26: {
                        Bytes value;
                        temp_block_hashes = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new BlockInfo(temp_last_block_number, temp_first_cons_time_of_last_block, temp_block_hashes);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new BlockInfo(temp_last_block_number, temp_first_cons_time_of_last_block, temp_block_hashes);
    }
}

