/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.codec.TopicJsonCodec;
import com.hedera.hapi.node.state.consensus.codec.TopicProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record Topic(@Nullable TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, @Nullable AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, @Nullable Key adminKey, @Nullable Key submitKey) {
    public static final Codec<Topic> PROTOBUF = new TopicProtoCodec();
    public static final JsonCodec<Topic> JSON = new TopicJsonCodec();
    public static final Topic DEFAULT = Topic.newBuilder().build();

    public boolean hasTopicId() {
        return this.topicId != null;
    }

    public TopicID topicIdOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicId() ? this.topicId : defaultValue;
    }

    @NonNull
    public TopicID topicIdOrThrow() {
        return Objects.requireNonNull(this.topicId, "Field topicId is null");
    }

    public void ifTopicId(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicId()) {
            ifPresent.accept(this.topicId);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TopicID topicId = null;
        private long sequenceNumber = 0L;
        private long expirationSecond = 0L;
        private long autoRenewPeriod = 0L;
        private AccountID autoRenewAccountId = null;
        private boolean deleted = false;
        private Bytes runningHash = Bytes.EMPTY;
        private String memo = "";
        private Key adminKey = null;
        private Key submitKey = null;

        public Builder() {
        }

        public Builder(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey) {
            this.topicId = topicId;
            this.sequenceNumber = sequenceNumber;
            this.expirationSecond = expirationSecond;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.deleted = deleted;
            this.runningHash = runningHash;
            this.memo = memo;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
        }

        public Topic build() {
            return new Topic(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey);
        }

        public Builder topicId(TopicID topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder topicId(TopicID.Builder builder) {
            this.topicId = builder.build();
            return this;
        }

        public Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder autoRenewPeriod(long autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewAccountId(AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder runningHash(Bytes runningHash) {
            this.runningHash = runningHash;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }
    }
}

