/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class TopicJsonCodec
implements JsonCodec<Topic> {
    @NonNull
    public Topic parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        TopicID temp_topic_id = null;
        long temp_sequence_number = 0L;
        long temp_expiration_second = 0L;
        long temp_auto_renew_period = 0L;
        AccountID temp_auto_renew_account_id = null;
        boolean temp_deleted = false;
        Bytes temp_running_hash = Bytes.EMPTY;
        String temp_memo = "";
        Key temp_admin_key = null;
        Key temp_submit_key = null;
        block24: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "topicId": {
                    temp_topic_id = (TopicID)TopicID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block24;
                }
                case "sequenceNumber": {
                    temp_sequence_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "expirationSecond": {
                    temp_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "autoRenewPeriod": {
                    temp_auto_renew_period = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "autoRenewAccountId": {
                    temp_auto_renew_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block24;
                }
                case "deleted": {
                    temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                    continue block24;
                }
                case "runningHash": {
                    temp_running_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "memo": {
                    temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block24;
                }
                case "adminKey": {
                    temp_admin_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block24;
                }
                case "submitKey": {
                    temp_submit_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block24;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new Topic(temp_topic_id, temp_sequence_number, temp_expiration_second, temp_auto_renew_period, temp_auto_renew_account_id, temp_deleted, temp_running_hash, temp_memo, temp_admin_key, temp_submit_key);
    }

    public String toJSON(@NonNull Topic data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.topicId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"topicId", TopicID.JSON, (Object)data.topicId()));
        }
        if (data.sequenceNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"sequenceNumber", (long)data.sequenceNumber()));
        }
        if (data.expirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"expirationSecond", (long)data.expirationSecond()));
        }
        if (data.autoRenewPeriod() != 0L) {
            fieldLines.add(JsonTools.field((String)"autoRenewPeriod", (long)data.autoRenewPeriod()));
        }
        if (data.autoRenewAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccountId", AccountID.JSON, (Object)data.autoRenewAccountId()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.runningHash() != Bytes.EMPTY && data.runningHash() != null && data.runningHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"runningHash", (Bytes)data.runningHash()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.submitKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"submitKey", Key.JSON, (Object)data.submitKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

