/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.state.consensus.schema.TopicSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TopicProtoCodec
implements Codec<Topic> {
    @NonNull
    public Topic parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Topic parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Topic data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), (arg_0, arg_1) -> TopicID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TopicSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Topic data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TopicSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull Topic item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Topic parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_topic_id = null;
        long temp_sequence_number = 0L;
        long temp_expiration_second = 0L;
        long temp_auto_renew_period = 0L;
        Record temp_auto_renew_account_id = null;
        boolean temp_deleted = false;
        Bytes temp_running_hash = Bytes.EMPTY;
        String temp_memo = "";
        Record temp_admin_key = null;
        Record temp_submit_key = null;
        try {
            block14: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TopicSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TopicID)TopicID.PROTOBUF.parseStrict(input) : (TopicID)TopicID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_topic_id = value;
                        continue block14;
                    }
                    case 16: {
                        long value;
                        temp_sequence_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 24: {
                        long value;
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 32: {
                        long value;
                        temp_auto_renew_period = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_auto_renew_account_id = value;
                        continue block14;
                    }
                    case 48: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 58: {
                        Bytes value;
                        temp_running_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 66: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block14;
                    }
                    case 74: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_admin_key = value;
                        continue block14;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_submit_key = value;
                        continue block14;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Topic((TopicID)temp_topic_id, temp_sequence_number, temp_expiration_second, temp_auto_renew_period, (AccountID)temp_auto_renew_account_id, temp_deleted, temp_running_hash, temp_memo, (Key)temp_admin_key, (Key)temp_submit_key);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Topic((TopicID)temp_topic_id, temp_sequence_number, temp_expiration_second, temp_auto_renew_period, (AccountID)temp_auto_renew_account_id, temp_deleted, temp_running_hash, temp_memo, (Key)temp_admin_key, (Key)temp_submit_key);
    }
}

