/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract.codec;

import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class SlotKeyJsonCodec
implements JsonCodec<SlotKey> {
    @NonNull
    public SlotKey parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        long temp_contract_number = 0L;
        Bytes temp_key = Bytes.EMPTY;
        block8: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "contractNumber": {
                    temp_contract_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block8;
                }
                case "key": {
                    temp_key = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block8;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new SlotKey(temp_contract_number, temp_key);
    }

    public String toJSON(@NonNull SlotKey data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"contractNumber", (long)data.contractNumber()));
        }
        if (data.key() != Bytes.EMPTY && data.key() != null && data.key().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"key", (Bytes)data.key()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

