/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.file.schema.FileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FileProtoCodec
implements Codec<File> {
    @NonNull
    public File parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public File parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull File data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileSchema.FILE_ID, (Object)data.fileId(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)FileSchema.CONTENTS, (RandomAccessData)data.contents());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)FileSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)FileSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileSchema.PRE_SYSTEM_DELETE_EXPIRATION_SECOND, (long)data.preSystemDeleteExpirationSecond());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(File data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.FILE_ID, (Object)data.fileId(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileSchema.CONTENTS, (RandomAccessData)data.contents());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)FileSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FileSchema.DELETED, (boolean)data.deleted());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.PRE_SYSTEM_DELETE_EXPIRATION_SECOND, (long)data.preSystemDeleteExpirationSecond());
    }

    public boolean fastEquals(@NonNull File item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private File parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_file_id = null;
        long temp_expiration_second = 0L;
        Record temp_keys = null;
        Bytes temp_contents = Bytes.EMPTY;
        String temp_memo = "";
        boolean temp_deleted = false;
        long temp_pre_system_delete_expiration_second = 0L;
        try {
            block11: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FileSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_file_id = value;
                        continue block11;
                    }
                    case 16: {
                        long value;
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_keys = value;
                        continue block11;
                    }
                    case 34: {
                        Bytes value;
                        temp_contents = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 42: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 48: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 56: {
                        long value;
                        temp_pre_system_delete_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block11;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new File((FileID)temp_file_id, temp_expiration_second, (KeyList)temp_keys, temp_contents, temp_memo, temp_deleted, temp_pre_system_delete_expiration_second);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new File((FileID)temp_file_id, temp_expiration_second, (KeyList)temp_keys, temp_contents, temp_memo, temp_deleted, temp_pre_system_delete_expiration_second);
    }
}

