/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.primitives.codec;

import com.hedera.hapi.node.state.primitives.ProtoInteger;
import com.hedera.hapi.node.state.primitives.schema.ProtoIntegerSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ProtoIntegerProtoCodec
implements Codec<ProtoInteger> {
    @NonNull
    public ProtoInteger parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ProtoInteger parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ProtoInteger data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ProtoIntegerSchema.VALUE, (int)data.value());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ProtoInteger data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ProtoIntegerSchema.VALUE, (int)data.value());
    }

    public boolean fastEquals(@NonNull ProtoInteger item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ProtoInteger parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        int temp_value = 0;
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ProtoIntegerSchema.getField(field);
                switch (tag) {
                    case 8: {
                        int value;
                        temp_value = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ProtoInteger(temp_value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ProtoInteger(temp_value);
    }
}

