/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.codec.AccountCryptoAllowanceJsonCodec;
import com.hedera.hapi.node.state.token.codec.AccountCryptoAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountCryptoAllowance(@Nullable AccountID spenderId, long amount) {
    public static final Codec<AccountCryptoAllowance> PROTOBUF = new AccountCryptoAllowanceProtoCodec();
    public static final JsonCodec<AccountCryptoAllowance> JSON = new AccountCryptoAllowanceJsonCodec();
    public static final AccountCryptoAllowance DEFAULT = AccountCryptoAllowance.newBuilder().build();

    public boolean hasSpenderId() {
        return this.spenderId != null;
    }

    public AccountID spenderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpenderId() ? this.spenderId : defaultValue;
    }

    @NonNull
    public AccountID spenderIdOrThrow() {
        return Objects.requireNonNull(this.spenderId, "Field spenderId is null");
    }

    public void ifSpenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpenderId()) {
            ifPresent.accept(this.spenderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.spenderId, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID spenderId = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(AccountID spenderId, long amount) {
            this.spenderId = spenderId;
            this.amount = amount;
        }

        public AccountCryptoAllowance build() {
            return new AccountCryptoAllowance(this.spenderId, this.amount);
        }

        public Builder spenderId(AccountID spenderId) {
            this.spenderId = spenderId;
            return this;
        }

        public Builder spenderId(AccountID.Builder builder) {
            this.spenderId = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

