/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.schema.AccountSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class AccountProtoCodec
implements Codec<Account> {
    public static final OneOf<Account.StakedIdOneOfType> STAKED_ID_UNSET = new OneOf((Object)Account.StakedIdOneOfType.UNSET, null);

    @NonNull
    public Account parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Account parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Account data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.ACCOUNT_ID, (Object)data.accountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)AccountSchema.ALIAS, (RandomAccessData)data.alias());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.KEY, (Object)data.key(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.TINYBAR_BALANCE, (long)data.tinybarBalance());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)AccountSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.STAKED_TO_ME, (long)data.stakedToMe());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.STAKE_PERIOD_START, (long)data.stakePeriodStart());
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)data.stakedId().as()), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_NODE_ID) {
            ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.STAKED_NODE_ID, (long)((Long)data.stakedId().as()));
        }
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountSchema.DECLINE_REWARD, (boolean)data.declineReward());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountSchema.RECEIVER_SIG_REQUIRED, (boolean)data.receiverSigRequired());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.HEAD_TOKEN_ID, (Object)data.headTokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.HEAD_NFT_ID, (Object)data.headNftId(), (arg_0, arg_1) -> NftID.PROTOBUF.write(arg_0, arg_1), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.HEAD_NFT_SERIAL_NUMBER, (long)data.headNftSerialNumber());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.NUMBER_OWNED_NFTS, (long)data.numberOwnedNfts());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.MAX_AUTO_ASSOCIATIONS, (int)data.maxAutoAssociations());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.USED_AUTO_ASSOCIATIONS, (int)data.usedAutoAssociations());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.NUMBER_ASSOCIATIONS, (int)data.numberAssociations());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountSchema.SMART_CONTRACT, (boolean)data.smartContract());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.NUMBER_POSITIVE_BALANCES, (int)data.numberPositiveBalances());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.ETHEREUM_NONCE, (long)data.ethereumNonce());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.STAKE_AT_START_OF_LAST_REWARDED_PERIOD, (long)data.stakeAtStartOfLastRewardedPeriod());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountSchema.AUTO_RENEW_SECONDS, (long)data.autoRenewSeconds());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.CONTRACT_KV_PAIRS_NUMBER, (int)data.contractKvPairsNumber());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AccountSchema.CRYPTO_ALLOWANCES, data.cryptoAllowances(), (arg_0, arg_1) -> AccountCryptoAllowance.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountCryptoAllowance.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AccountSchema.APPROVE_FOR_ALL_NFT_ALLOWANCES, data.approveForAllNftAllowances(), (arg_0, arg_1) -> AccountApprovalForAllAllowance.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountApprovalForAllAllowance.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AccountSchema.TOKEN_ALLOWANCES, data.tokenAllowances(), (arg_0, arg_1) -> AccountFungibleTokenAllowance.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountFungibleTokenAllowance.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountSchema.NUMBER_TREASURY_TITLES, (int)data.numberTreasuryTitles());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountSchema.EXPIRED_AND_PENDING_REMOVAL, (boolean)data.expiredAndPendingRemoval());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)AccountSchema.FIRST_CONTRACT_STORAGE_KEY, (RandomAccessData)data.firstContractStorageKey());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Account data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.ACCOUNT_ID, (Object)data.accountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountSchema.ALIAS, (RandomAccessData)data.alias());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.KEY, (Object)data.key(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.TINYBAR_BALANCE, (long)data.tinybarBalance());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)AccountSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKED_TO_ME, (long)data.stakedToMe());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKE_PERIOD_START, (long)data.stakePeriodStart());
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_ACCOUNT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.STAKED_ACCOUNT_ID, (Object)((AccountID)data.stakedId().as()), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.stakedId().kind() == Account.StakedIdOneOfType.STAKED_NODE_ID) {
            size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKED_NODE_ID, (long)((Long)data.stakedId().as()));
        }
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.DECLINE_REWARD, (boolean)data.declineReward());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.RECEIVER_SIG_REQUIRED, (boolean)data.receiverSigRequired());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.HEAD_TOKEN_ID, (Object)data.headTokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.HEAD_NFT_ID, (Object)data.headNftId(), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.HEAD_NFT_SERIAL_NUMBER, (long)data.headNftSerialNumber());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.NUMBER_OWNED_NFTS, (long)data.numberOwnedNfts());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.MAX_AUTO_ASSOCIATIONS, (int)data.maxAutoAssociations());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.USED_AUTO_ASSOCIATIONS, (int)data.usedAutoAssociations());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_ASSOCIATIONS, (int)data.numberAssociations());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.SMART_CONTRACT, (boolean)data.smartContract());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_POSITIVE_BALANCES, (int)data.numberPositiveBalances());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.ETHEREUM_NONCE, (long)data.ethereumNonce());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.STAKE_AT_START_OF_LAST_REWARDED_PERIOD, (long)data.stakeAtStartOfLastRewardedPeriod());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountSchema.AUTO_RENEW_SECONDS, (long)data.autoRenewSeconds());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.CONTRACT_KV_PAIRS_NUMBER, (int)data.contractKvPairsNumber());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.CRYPTO_ALLOWANCES, data.cryptoAllowances(), arg_0 -> AccountCryptoAllowance.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.APPROVE_FOR_ALL_NFT_ALLOWANCES, data.approveForAllNftAllowances(), arg_0 -> AccountApprovalForAllAllowance.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountSchema.TOKEN_ALLOWANCES, data.tokenAllowances(), arg_0 -> AccountFungibleTokenAllowance.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountSchema.NUMBER_TREASURY_TITLES, (int)data.numberTreasuryTitles());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountSchema.EXPIRED_AND_PENDING_REMOVAL, (boolean)data.expiredAndPendingRemoval());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountSchema.FIRST_CONTRACT_STORAGE_KEY, (RandomAccessData)data.firstContractStorageKey());
    }

    public boolean fastEquals(@NonNull Account item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Account parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_account_id = null;
        Bytes temp_alias = Bytes.EMPTY;
        Record temp_key = null;
        long temp_expiration_second = 0L;
        long temp_tinybar_balance = 0L;
        String temp_memo = "";
        boolean temp_deleted = false;
        long temp_staked_to_me = 0L;
        long temp_stake_period_start = 0L;
        OneOf temp_staked_id = STAKED_ID_UNSET;
        boolean temp_decline_reward = false;
        boolean temp_receiver_sig_required = false;
        Record temp_head_token_id = null;
        Record temp_head_nft_id = null;
        long temp_head_nft_serial_number = 0L;
        long temp_number_owned_nfts = 0L;
        int temp_max_auto_associations = 0;
        int temp_used_auto_associations = 0;
        int temp_number_associations = 0;
        boolean temp_smart_contract = false;
        int temp_number_positive_balances = 0;
        long temp_ethereum_nonce = 0L;
        long temp_stake_at_start_of_last_rewarded_period = 0L;
        Record temp_auto_renew_account_id = null;
        long temp_auto_renew_seconds = 0L;
        int temp_contract_kv_pairs_number = 0;
        List temp_crypto_allowances = Collections.emptyList();
        List temp_approve_for_all_nft_allowances = Collections.emptyList();
        List temp_token_allowances = Collections.emptyList();
        int temp_number_treasury_titles = 0;
        boolean temp_expired_and_pending_removal = false;
        Bytes temp_first_contract_storage_key = Bytes.EMPTY;
        try {
            block37: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = AccountSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_account_id = value;
                        continue block37;
                    }
                    case 18: {
                        Bytes value;
                        temp_alias = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = value;
                        continue block37;
                    }
                    case 32: {
                        long value;
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 40: {
                        long value;
                        temp_tinybar_balance = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 50: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 56: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 64: {
                        long value;
                        temp_staked_to_me = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 72: {
                        long value;
                        temp_stake_period_start = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_staked_id = new OneOf((Object)Account.StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)value);
                        continue block37;
                    }
                    case 88: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_staked_id = new OneOf((Object)Account.StakedIdOneOfType.STAKED_NODE_ID, (Object)value);
                        continue block37;
                    }
                    case 96: {
                        boolean value;
                        temp_decline_reward = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 104: {
                        boolean value;
                        temp_receiver_sig_required = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 114: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_head_token_id = value;
                        continue block37;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NftID)NftID.PROTOBUF.parseStrict(input) : (NftID)NftID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_head_nft_id = value;
                        continue block37;
                    }
                    case 128: {
                        long value;
                        temp_head_nft_serial_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 136: {
                        long value;
                        temp_number_owned_nfts = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 144: {
                        int value;
                        temp_max_auto_associations = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 152: {
                        int value;
                        temp_used_auto_associations = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 160: {
                        int value;
                        temp_number_associations = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 168: {
                        boolean value;
                        temp_smart_contract = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 176: {
                        int value;
                        temp_number_positive_balances = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 184: {
                        long value;
                        temp_ethereum_nonce = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 192: {
                        long value;
                        temp_stake_at_start_of_last_rewarded_period = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 202: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_auto_renew_account_id = value;
                        continue block37;
                    }
                    case 208: {
                        long value;
                        temp_auto_renew_seconds = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 216: {
                        int value;
                        temp_contract_kv_pairs_number = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 226: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountCryptoAllowance)AccountCryptoAllowance.PROTOBUF.parseStrict(input) : (AccountCryptoAllowance)AccountCryptoAllowance.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_crypto_allowances = ProtoParserTools.addToList(temp_crypto_allowances, (Object)value);
                        continue block37;
                    }
                    case 234: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountApprovalForAllAllowance)AccountApprovalForAllAllowance.PROTOBUF.parseStrict(input) : (AccountApprovalForAllAllowance)AccountApprovalForAllAllowance.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_approve_for_all_nft_allowances = ProtoParserTools.addToList(temp_approve_for_all_nft_allowances, (Object)value);
                        continue block37;
                    }
                    case 242: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountFungibleTokenAllowance)AccountFungibleTokenAllowance.PROTOBUF.parseStrict(input) : (AccountFungibleTokenAllowance)AccountFungibleTokenAllowance.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_token_allowances = ProtoParserTools.addToList(temp_token_allowances, (Object)value);
                        continue block37;
                    }
                    case 248: {
                        int value;
                        temp_number_treasury_titles = value = ProtoParserTools.readUint32((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 256: {
                        boolean value;
                        temp_expired_and_pending_removal = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block37;
                    }
                    case 266: {
                        Bytes value;
                        temp_first_contract_storage_key = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block37;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Account((AccountID)temp_account_id, temp_alias, (Key)temp_key, temp_expiration_second, temp_tinybar_balance, temp_memo, temp_deleted, temp_staked_to_me, temp_stake_period_start, (OneOf<Account.StakedIdOneOfType>)temp_staked_id, temp_decline_reward, temp_receiver_sig_required, (TokenID)temp_head_token_id, (NftID)temp_head_nft_id, temp_head_nft_serial_number, temp_number_owned_nfts, temp_max_auto_associations, temp_used_auto_associations, temp_number_associations, temp_smart_contract, temp_number_positive_balances, temp_ethereum_nonce, temp_stake_at_start_of_last_rewarded_period, (AccountID)temp_auto_renew_account_id, temp_auto_renew_seconds, temp_contract_kv_pairs_number, temp_crypto_allowances, temp_approve_for_all_nft_allowances, temp_token_allowances, temp_number_treasury_titles, temp_expired_and_pending_removal, temp_first_contract_storage_key);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Account((AccountID)temp_account_id, temp_alias, (Key)temp_key, temp_expiration_second, temp_tinybar_balance, temp_memo, temp_deleted, temp_staked_to_me, temp_stake_period_start, (OneOf<Account.StakedIdOneOfType>)temp_staked_id, temp_decline_reward, temp_receiver_sig_required, (TokenID)temp_head_token_id, (NftID)temp_head_nft_id, temp_head_nft_serial_number, temp_number_owned_nfts, temp_max_auto_associations, temp_used_auto_associations, temp_number_associations, temp_smart_contract, temp_number_positive_balances, temp_ethereum_nonce, temp_stake_at_start_of_last_rewarded_period, (AccountID)temp_auto_renew_account_id, temp_auto_renew_seconds, temp_contract_kv_pairs_number, temp_crypto_allowances, temp_approve_for_all_nft_allowances, temp_token_allowances, temp_number_treasury_titles, temp_expired_and_pending_removal, temp_first_contract_storage_key);
    }
}

