/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.schema.TokenSchema;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TokenProtoCodec
implements Codec<Token> {
    @NonNull
    public Token parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Token parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Token data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.TOKEN_ID, (Object)data.tokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenSchema.NAME, (String)data.name());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenSchema.SYMBOL, (String)data.symbol());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TokenSchema.DECIMALS, (int)data.decimals());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenSchema.TOTAL_SUPPLY, (long)data.totalSupply());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.TREASURY_ACCOUNT_ID, (Object)data.treasuryAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.KYC_KEY, (Object)data.kycKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.FREEZE_KEY, (Object)data.freezeKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.WIPE_KEY, (Object)data.wipeKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.SUPPLY_KEY, (Object)data.supplyKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.PAUSE_KEY, (Object)data.pauseKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenSchema.LAST_USED_SERIAL_NUMBER, (long)data.lastUsedSerialNumber());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TokenSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenSchema.TOKEN_TYPE, (EnumWithProtoMetadata)data.tokenType());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenSchema.SUPPLY_TYPE, (EnumWithProtoMetadata)data.supplyType());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenSchema.AUTO_RENEW_SECONDS, (long)data.autoRenewSeconds());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenSchema.MAX_SUPPLY, (long)data.maxSupply());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TokenSchema.PAUSED, (boolean)data.paused());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TokenSchema.ACCOUNTS_FROZEN_BY_DEFAULT, (boolean)data.accountsFrozenByDefault());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TokenSchema.ACCOUNTS_KYC_GRANTED_BY_DEFAULT, (boolean)data.accountsKycGrantedByDefault());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TokenSchema.CUSTOM_FEES, data.customFees(), (arg_0, arg_1) -> CustomFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> CustomFee.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Token data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.TOKEN_ID, (Object)data.tokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.NAME, (String)data.name());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.SYMBOL, (String)data.symbol());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TokenSchema.DECIMALS, (int)data.decimals());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.TOTAL_SUPPLY, (long)data.totalSupply());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.TREASURY_ACCOUNT_ID, (Object)data.treasuryAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.KYC_KEY, (Object)data.kycKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.FREEZE_KEY, (Object)data.freezeKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.WIPE_KEY, (Object)data.wipeKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.SUPPLY_KEY, (Object)data.supplyKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.PAUSE_KEY, (Object)data.pauseKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.LAST_USED_SERIAL_NUMBER, (long)data.lastUsedSerialNumber());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenSchema.TOKEN_TYPE, (EnumWithProtoMetadata)data.tokenType());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenSchema.SUPPLY_TYPE, (EnumWithProtoMetadata)data.supplyType());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.AUTO_RENEW_SECONDS, (long)data.autoRenewSeconds());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenSchema.MAX_SUPPLY, (long)data.maxSupply());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.PAUSED, (boolean)data.paused());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.ACCOUNTS_FROZEN_BY_DEFAULT, (boolean)data.accountsFrozenByDefault());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenSchema.ACCOUNTS_KYC_GRANTED_BY_DEFAULT, (boolean)data.accountsKycGrantedByDefault());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenSchema.CUSTOM_FEES, data.customFees(), arg_0 -> CustomFee.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull Token item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Token parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_token_id = null;
        String temp_name = "";
        String temp_symbol = "";
        int temp_decimals = 0;
        long temp_total_supply = 0L;
        Record temp_treasury_account_id = null;
        Record temp_admin_key = null;
        Record temp_kyc_key = null;
        Record temp_freeze_key = null;
        Record temp_wipe_key = null;
        Record temp_supply_key = null;
        Record temp_fee_schedule_key = null;
        Record temp_pause_key = null;
        long temp_last_used_serial_number = 0L;
        boolean temp_deleted = false;
        TokenType temp_token_type = TokenType.values()[0];
        TokenSupplyType temp_supply_type = TokenSupplyType.values()[0];
        Record temp_auto_renew_account_id = null;
        long temp_auto_renew_seconds = 0L;
        long temp_expiration_second = 0L;
        String temp_memo = "";
        long temp_max_supply = 0L;
        boolean temp_paused = false;
        boolean temp_accounts_frozen_by_default = false;
        boolean temp_accounts_kyc_granted_by_default = false;
        List temp_custom_fees = Collections.emptyList();
        try {
            block30: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_token_id = value;
                        continue block30;
                    }
                    case 18: {
                        String value;
                        temp_name = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 26: {
                        String value;
                        temp_symbol = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 32: {
                        int value;
                        temp_decimals = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 40: {
                        long value;
                        temp_total_supply = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_treasury_account_id = value;
                        continue block30;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_admin_key = value;
                        continue block30;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_kyc_key = value;
                        continue block30;
                    }
                    case 74: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_freeze_key = value;
                        continue block30;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_wipe_key = value;
                        continue block30;
                    }
                    case 90: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_supply_key = value;
                        continue block30;
                    }
                    case 98: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee_schedule_key = value;
                        continue block30;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_pause_key = value;
                        continue block30;
                    }
                    case 112: {
                        long value;
                        temp_last_used_serial_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 120: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 128: {
                        TokenType value;
                        temp_token_type = value = TokenType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 136: {
                        TokenSupplyType value;
                        temp_supply_type = value = TokenSupplyType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 146: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_auto_renew_account_id = value;
                        continue block30;
                    }
                    case 152: {
                        long value;
                        temp_auto_renew_seconds = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 160: {
                        long value;
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 170: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 176: {
                        long value;
                        temp_max_supply = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 184: {
                        boolean value;
                        temp_paused = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 192: {
                        boolean value;
                        temp_accounts_frozen_by_default = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 200: {
                        boolean value;
                        temp_accounts_kyc_granted_by_default = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 210: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (CustomFee)CustomFee.PROTOBUF.parseStrict(input) : (CustomFee)CustomFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_custom_fees = ProtoParserTools.addToList(temp_custom_fees, (Object)value);
                        continue block30;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Token((TokenID)temp_token_id, temp_name, temp_symbol, temp_decimals, temp_total_supply, (AccountID)temp_treasury_account_id, (Key)temp_admin_key, (Key)temp_kyc_key, (Key)temp_freeze_key, (Key)temp_wipe_key, (Key)temp_supply_key, (Key)temp_fee_schedule_key, (Key)temp_pause_key, temp_last_used_serial_number, temp_deleted, temp_token_type, temp_supply_type, (AccountID)temp_auto_renew_account_id, temp_auto_renew_seconds, temp_expiration_second, temp_memo, temp_max_supply, temp_paused, temp_accounts_frozen_by_default, temp_accounts_kyc_granted_by_default, temp_custom_fees);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Token((TokenID)temp_token_id, temp_name, temp_symbol, temp_decimals, temp_total_supply, (AccountID)temp_treasury_account_id, (Key)temp_admin_key, (Key)temp_kyc_key, (Key)temp_freeze_key, (Key)temp_wipe_key, (Key)temp_supply_key, (Key)temp_fee_schedule_key, (Key)temp_pause_key, temp_last_used_serial_number, temp_deleted, temp_token_type, temp_supply_type, (AccountID)temp_auto_renew_account_id, temp_auto_renew_seconds, temp_expiration_second, temp_memo, temp_max_supply, temp_paused, temp_accounts_frozen_by_default, temp_accounts_kyc_granted_by_default, temp_custom_fees);
    }
}

