/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.token.codec.AccountInfoJsonCodec;
import com.hedera.hapi.node.token.codec.AccountInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountInfo(@Nullable AccountID accountID, String contractAccountID, boolean deleted, @Nullable AccountID proxyAccountID, long proxyReceived, @Nullable Key key, long balance, long generateSendRecordThreshold, long generateReceiveRecordThreshold, boolean receiverSigRequired, @Nullable Timestamp expirationTime, @Nullable Duration autoRenewPeriod, @Nullable List<LiveHash> liveHashes, @Nullable List<TokenRelationship> tokenRelationships, String memo, long ownedNfts, int maxAutomaticTokenAssociations, Bytes alias, Bytes ledgerId, long ethereumNonce, @Nullable StakingInfo stakingInfo) {
    public static final Codec<AccountInfo> PROTOBUF = new AccountInfoProtoCodec();
    public static final JsonCodec<AccountInfo> JSON = new AccountInfoJsonCodec();
    public static final AccountInfo DEFAULT = AccountInfo.newBuilder().build();

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasProxyAccountID() {
        return this.proxyAccountID != null;
    }

    public AccountID proxyAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasProxyAccountID() ? this.proxyAccountID : defaultValue;
    }

    @NonNull
    public AccountID proxyAccountIDOrThrow() {
        return Objects.requireNonNull(this.proxyAccountID, "Field proxyAccountID is null");
    }

    public void ifProxyAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasProxyAccountID()) {
            ifPresent.accept(this.proxyAccountID);
        }
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public Key keyOrElse(@NonNull Key defaultValue) {
        return this.hasKey() ? this.key : defaultValue;
    }

    @NonNull
    public Key keyOrThrow() {
        return Objects.requireNonNull(this.key, "Field key is null");
    }

    public void ifKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKey()) {
            ifPresent.accept(this.key);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasLiveHashes() {
        return this.liveHashes != null;
    }

    public List<LiveHash> liveHashesOrElse(@NonNull List<LiveHash> defaultValue) {
        return this.hasLiveHashes() ? this.liveHashes : defaultValue;
    }

    @NonNull
    public List<LiveHash> liveHashesOrThrow() {
        return Objects.requireNonNull(this.liveHashes, "Field liveHashes is null");
    }

    public void ifLiveHashes(@NonNull Consumer<List<LiveHash>> ifPresent) {
        if (this.hasLiveHashes()) {
            ifPresent.accept(this.liveHashes);
        }
    }

    public boolean hasTokenRelationships() {
        return this.tokenRelationships != null;
    }

    public List<TokenRelationship> tokenRelationshipsOrElse(@NonNull List<TokenRelationship> defaultValue) {
        return this.hasTokenRelationships() ? this.tokenRelationships : defaultValue;
    }

    @NonNull
    public List<TokenRelationship> tokenRelationshipsOrThrow() {
        return Objects.requireNonNull(this.tokenRelationships, "Field tokenRelationships is null");
    }

    public void ifTokenRelationships(@NonNull Consumer<List<TokenRelationship>> ifPresent) {
        if (this.hasTokenRelationships()) {
            ifPresent.accept(this.tokenRelationships);
        }
    }

    public boolean hasStakingInfo() {
        return this.stakingInfo != null;
    }

    public StakingInfo stakingInfoOrElse(@NonNull StakingInfo defaultValue) {
        return this.hasStakingInfo() ? this.stakingInfo : defaultValue;
    }

    @NonNull
    public StakingInfo stakingInfoOrThrow() {
        return Objects.requireNonNull(this.stakingInfo, "Field stakingInfo is null");
    }

    public void ifStakingInfo(@NonNull Consumer<StakingInfo> ifPresent) {
        if (this.hasStakingInfo()) {
            ifPresent.accept(this.stakingInfo);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.contractAccountID, this.deleted, this.proxyAccountID, this.proxyReceived, this.key, this.balance, this.generateSendRecordThreshold, this.generateReceiveRecordThreshold, this.receiverSigRequired, this.expirationTime, this.autoRenewPeriod, this.liveHashes, this.tokenRelationships, this.memo, this.ownedNfts, this.maxAutomaticTokenAssociations, this.alias, this.ledgerId, this.ethereumNonce, this.stakingInfo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountID = null;
        private String contractAccountID = "";
        private boolean deleted = false;
        private AccountID proxyAccountID = null;
        private long proxyReceived = 0L;
        private Key key = null;
        private long balance = 0L;
        private long generateSendRecordThreshold = 0L;
        private long generateReceiveRecordThreshold = 0L;
        private boolean receiverSigRequired = false;
        private Timestamp expirationTime = null;
        private Duration autoRenewPeriod = null;
        private List<LiveHash> liveHashes = Collections.emptyList();
        private List<TokenRelationship> tokenRelationships = Collections.emptyList();
        private String memo = "";
        private long ownedNfts = 0L;
        private int maxAutomaticTokenAssociations = 0;
        private Bytes alias = Bytes.EMPTY;
        private Bytes ledgerId = Bytes.EMPTY;
        private long ethereumNonce = 0L;
        private StakingInfo stakingInfo = null;

        public Builder() {
        }

        public Builder(AccountID accountID, String contractAccountID, boolean deleted, AccountID proxyAccountID, long proxyReceived, Key key, long balance, long generateSendRecordThreshold, long generateReceiveRecordThreshold, boolean receiverSigRequired, Timestamp expirationTime, Duration autoRenewPeriod, List<LiveHash> liveHashes, List<TokenRelationship> tokenRelationships, String memo, long ownedNfts, int maxAutomaticTokenAssociations, Bytes alias, Bytes ledgerId, long ethereumNonce, StakingInfo stakingInfo) {
            this.accountID = accountID;
            this.contractAccountID = contractAccountID;
            this.deleted = deleted;
            this.proxyAccountID = proxyAccountID;
            this.proxyReceived = proxyReceived;
            this.key = key;
            this.balance = balance;
            this.generateSendRecordThreshold = generateSendRecordThreshold;
            this.generateReceiveRecordThreshold = generateReceiveRecordThreshold;
            this.receiverSigRequired = receiverSigRequired;
            this.expirationTime = expirationTime;
            this.autoRenewPeriod = autoRenewPeriod;
            this.liveHashes = liveHashes;
            this.tokenRelationships = tokenRelationships;
            this.memo = memo;
            this.ownedNfts = ownedNfts;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.alias = alias;
            this.ledgerId = ledgerId;
            this.ethereumNonce = ethereumNonce;
            this.stakingInfo = stakingInfo;
        }

        public AccountInfo build() {
            return new AccountInfo(this.accountID, this.contractAccountID, this.deleted, this.proxyAccountID, this.proxyReceived, this.key, this.balance, this.generateSendRecordThreshold, this.generateReceiveRecordThreshold, this.receiverSigRequired, this.expirationTime, this.autoRenewPeriod, this.liveHashes, this.tokenRelationships, this.memo, this.ownedNfts, this.maxAutomaticTokenAssociations, this.alias, this.ledgerId, this.ethereumNonce, this.stakingInfo);
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder contractAccountID(String contractAccountID) {
            this.contractAccountID = contractAccountID;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder proxyAccountID(AccountID proxyAccountID) {
            this.proxyAccountID = proxyAccountID;
            return this;
        }

        public Builder proxyAccountID(AccountID.Builder builder) {
            this.proxyAccountID = builder.build();
            return this;
        }

        public Builder proxyReceived(long proxyReceived) {
            this.proxyReceived = proxyReceived;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Key.Builder builder) {
            this.key = builder.build();
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder generateSendRecordThreshold(long generateSendRecordThreshold) {
            this.generateSendRecordThreshold = generateSendRecordThreshold;
            return this;
        }

        public Builder generateReceiveRecordThreshold(long generateReceiveRecordThreshold) {
            this.generateReceiveRecordThreshold = generateReceiveRecordThreshold;
            return this;
        }

        public Builder receiverSigRequired(boolean receiverSigRequired) {
            this.receiverSigRequired = receiverSigRequired;
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder liveHashes(List<LiveHash> liveHashes) {
            this.liveHashes = liveHashes;
            return this;
        }

        public Builder liveHashes(LiveHash ... values) {
            this.liveHashes = List.of(values);
            return this;
        }

        public Builder tokenRelationships(List<TokenRelationship> tokenRelationships) {
            this.tokenRelationships = tokenRelationships;
            return this;
        }

        public Builder tokenRelationships(TokenRelationship ... values) {
            this.tokenRelationships = List.of(values);
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder ownedNfts(long ownedNfts) {
            this.ownedNfts = ownedNfts;
            return this;
        }

        public Builder maxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder alias(Bytes alias) {
            this.alias = alias;
            return this;
        }

        public Builder ledgerId(Bytes ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public Builder ethereumNonce(long ethereumNonce) {
            this.ethereumNonce = ethereumNonce;
            return this;
        }

        public Builder stakingInfo(StakingInfo stakingInfo) {
            this.stakingInfo = stakingInfo;
            return this;
        }

        public Builder stakingInfo(StakingInfo.Builder builder) {
            this.stakingInfo = builder.build();
            return this;
        }
    }
}

