/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.codec.CryptoAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.CryptoAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record CryptoAllowance(@Nullable AccountID owner, @Nullable AccountID spender, long amount) {
    public static final Codec<CryptoAllowance> PROTOBUF = new CryptoAllowanceProtoCodec();
    public static final JsonCodec<CryptoAllowance> JSON = new CryptoAllowanceJsonCodec();
    public static final CryptoAllowance DEFAULT = CryptoAllowance.newBuilder().build();

    public boolean hasOwner() {
        return this.owner != null;
    }

    public AccountID ownerOrElse(@NonNull AccountID defaultValue) {
        return this.hasOwner() ? this.owner : defaultValue;
    }

    @NonNull
    public AccountID ownerOrThrow() {
        return Objects.requireNonNull(this.owner, "Field owner is null");
    }

    public void ifOwner(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasOwner()) {
            ifPresent.accept(this.owner);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.owner, this.spender, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID owner = null;
        private AccountID spender = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(AccountID owner, AccountID spender, long amount) {
            this.owner = owner;
            this.spender = spender;
            this.amount = amount;
        }

        public CryptoAllowance build() {
            return new CryptoAllowance(this.owner, this.spender, this.amount);
        }

        public Builder owner(AccountID owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(AccountID.Builder builder) {
            this.owner = builder.build();
            return this;
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

