/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.token.codec.CryptoCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.CryptoCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record CryptoCreateTransactionBody(@Nullable Key key, long initialBalance, @Nullable AccountID proxyAccountID, long sendRecordThreshold, long receiveRecordThreshold, boolean receiverSigRequired, @Nullable Duration autoRenewPeriod, @Nullable ShardID shardID, @Nullable RealmID realmID, @Nullable Key newRealmAdminKey, String memo, int maxAutomaticTokenAssociations, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, Bytes alias) {
    public static final Codec<CryptoCreateTransactionBody> PROTOBUF = new CryptoCreateTransactionBodyProtoCodec();
    public static final JsonCodec<CryptoCreateTransactionBody> JSON = new CryptoCreateTransactionBodyJsonCodec();
    public static final CryptoCreateTransactionBody DEFAULT = CryptoCreateTransactionBody.newBuilder().build();

    public CryptoCreateTransactionBody {
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public Key keyOrElse(@NonNull Key defaultValue) {
        return this.hasKey() ? this.key : defaultValue;
    }

    @NonNull
    public Key keyOrThrow() {
        return Objects.requireNonNull(this.key, "Field key is null");
    }

    public void ifKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKey()) {
            ifPresent.accept(this.key);
        }
    }

    public boolean hasProxyAccountID() {
        return this.proxyAccountID != null;
    }

    public AccountID proxyAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasProxyAccountID() ? this.proxyAccountID : defaultValue;
    }

    @NonNull
    public AccountID proxyAccountIDOrThrow() {
        return Objects.requireNonNull(this.proxyAccountID, "Field proxyAccountID is null");
    }

    public void ifProxyAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasProxyAccountID()) {
            ifPresent.accept(this.proxyAccountID);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasShardID() {
        return this.shardID != null;
    }

    public ShardID shardIDOrElse(@NonNull ShardID defaultValue) {
        return this.hasShardID() ? this.shardID : defaultValue;
    }

    @NonNull
    public ShardID shardIDOrThrow() {
        return Objects.requireNonNull(this.shardID, "Field shardID is null");
    }

    public void ifShardID(@NonNull Consumer<ShardID> ifPresent) {
        if (this.hasShardID()) {
            ifPresent.accept(this.shardID);
        }
    }

    public boolean hasRealmID() {
        return this.realmID != null;
    }

    public RealmID realmIDOrElse(@NonNull RealmID defaultValue) {
        return this.hasRealmID() ? this.realmID : defaultValue;
    }

    @NonNull
    public RealmID realmIDOrThrow() {
        return Objects.requireNonNull(this.realmID, "Field realmID is null");
    }

    public void ifRealmID(@NonNull Consumer<RealmID> ifPresent) {
        if (this.hasRealmID()) {
            ifPresent.accept(this.realmID);
        }
    }

    public boolean hasNewRealmAdminKey() {
        return this.newRealmAdminKey != null;
    }

    public Key newRealmAdminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasNewRealmAdminKey() ? this.newRealmAdminKey : defaultValue;
    }

    @NonNull
    public Key newRealmAdminKeyOrThrow() {
        return Objects.requireNonNull(this.newRealmAdminKey, "Field newRealmAdminKey is null");
    }

    public void ifNewRealmAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasNewRealmAdminKey()) {
            ifPresent.accept(this.newRealmAdminKey);
        }
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.key, this.initialBalance, this.proxyAccountID, this.sendRecordThreshold, this.receiveRecordThreshold, this.receiverSigRequired, this.autoRenewPeriod, this.shardID, this.realmID, this.newRealmAdminKey, this.memo, this.maxAutomaticTokenAssociations, this.stakedId, this.declineReward, this.alias);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(15, "staked_account_id"),
        STAKED_NODE_ID(16, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 16 -> STAKED_NODE_ID;
                case 15 -> STAKED_ACCOUNT_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "STAKED_NODE_ID", "staked_node_id" -> STAKED_NODE_ID;
                case "STAKED_ACCOUNT_ID", "staked_account_id" -> STAKED_ACCOUNT_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private Key key = null;
        private long initialBalance = 0L;
        private AccountID proxyAccountID = null;
        private long sendRecordThreshold = 0L;
        private long receiveRecordThreshold = 0L;
        private boolean receiverSigRequired = false;
        private Duration autoRenewPeriod = null;
        private ShardID shardID = null;
        private RealmID realmID = null;
        private Key newRealmAdminKey = null;
        private String memo = "";
        private int maxAutomaticTokenAssociations = 0;
        private OneOf<StakedIdOneOfType> stakedId = CryptoCreateTransactionBodyProtoCodec.STAKED_ID_UNSET;
        private boolean declineReward = false;
        private Bytes alias = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(Key key, long initialBalance, AccountID proxyAccountID, long sendRecordThreshold, long receiveRecordThreshold, boolean receiverSigRequired, Duration autoRenewPeriod, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo, int maxAutomaticTokenAssociations, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, Bytes alias) {
            this.key = key;
            this.initialBalance = initialBalance;
            this.proxyAccountID = proxyAccountID;
            this.sendRecordThreshold = sendRecordThreshold;
            this.receiveRecordThreshold = receiveRecordThreshold;
            this.receiverSigRequired = receiverSigRequired;
            this.autoRenewPeriod = autoRenewPeriod;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
            this.alias = alias;
        }

        public CryptoCreateTransactionBody build() {
            return new CryptoCreateTransactionBody(this.key, this.initialBalance, this.proxyAccountID, this.sendRecordThreshold, this.receiveRecordThreshold, this.receiverSigRequired, this.autoRenewPeriod, this.shardID, this.realmID, this.newRealmAdminKey, this.memo, this.maxAutomaticTokenAssociations, this.stakedId, this.declineReward, this.alias);
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Key.Builder builder) {
            this.key = builder.build();
            return this;
        }

        public Builder initialBalance(long initialBalance) {
            this.initialBalance = initialBalance;
            return this;
        }

        public Builder proxyAccountID(AccountID proxyAccountID) {
            this.proxyAccountID = proxyAccountID;
            return this;
        }

        public Builder proxyAccountID(AccountID.Builder builder) {
            this.proxyAccountID = builder.build();
            return this;
        }

        public Builder sendRecordThreshold(long sendRecordThreshold) {
            this.sendRecordThreshold = sendRecordThreshold;
            return this;
        }

        public Builder receiveRecordThreshold(long receiveRecordThreshold) {
            this.receiveRecordThreshold = receiveRecordThreshold;
            return this;
        }

        public Builder receiverSigRequired(boolean receiverSigRequired) {
            this.receiverSigRequired = receiverSigRequired;
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder shardID(ShardID shardID) {
            this.shardID = shardID;
            return this;
        }

        public Builder shardID(ShardID.Builder builder) {
            this.shardID = builder.build();
            return this;
        }

        public Builder realmID(RealmID realmID) {
            this.realmID = realmID;
            return this;
        }

        public Builder realmID(RealmID.Builder builder) {
            this.realmID = builder.build();
            return this;
        }

        public Builder newRealmAdminKey(Key newRealmAdminKey) {
            this.newRealmAdminKey = newRealmAdminKey;
            return this;
        }

        public Builder newRealmAdminKey(Key.Builder builder) {
            this.newRealmAdminKey = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder maxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder stakedAccountId(AccountID stakedAccountId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Object)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder alias(Bytes alias) {
            this.alias = alias;
            return this;
        }
    }
}

