/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.codec.CryptoDeleteTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.CryptoDeleteTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record CryptoDeleteTransactionBody(@Nullable AccountID transferAccountID, @Nullable AccountID deleteAccountID) {
    public static final Codec<CryptoDeleteTransactionBody> PROTOBUF = new CryptoDeleteTransactionBodyProtoCodec();
    public static final JsonCodec<CryptoDeleteTransactionBody> JSON = new CryptoDeleteTransactionBodyJsonCodec();
    public static final CryptoDeleteTransactionBody DEFAULT = CryptoDeleteTransactionBody.newBuilder().build();

    public boolean hasTransferAccountID() {
        return this.transferAccountID != null;
    }

    public AccountID transferAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasTransferAccountID() ? this.transferAccountID : defaultValue;
    }

    @NonNull
    public AccountID transferAccountIDOrThrow() {
        return Objects.requireNonNull(this.transferAccountID, "Field transferAccountID is null");
    }

    public void ifTransferAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTransferAccountID()) {
            ifPresent.accept(this.transferAccountID);
        }
    }

    public boolean hasDeleteAccountID() {
        return this.deleteAccountID != null;
    }

    public AccountID deleteAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasDeleteAccountID() ? this.deleteAccountID : defaultValue;
    }

    @NonNull
    public AccountID deleteAccountIDOrThrow() {
        return Objects.requireNonNull(this.deleteAccountID, "Field deleteAccountID is null");
    }

    public void ifDeleteAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasDeleteAccountID()) {
            ifPresent.accept(this.deleteAccountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transferAccountID, this.deleteAccountID);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID transferAccountID = null;
        private AccountID deleteAccountID = null;

        public Builder() {
        }

        public Builder(AccountID transferAccountID, AccountID deleteAccountID) {
            this.transferAccountID = transferAccountID;
            this.deleteAccountID = deleteAccountID;
        }

        public CryptoDeleteTransactionBody build() {
            return new CryptoDeleteTransactionBody(this.transferAccountID, this.deleteAccountID);
        }

        public Builder transferAccountID(AccountID transferAccountID) {
            this.transferAccountID = transferAccountID;
            return this;
        }

        public Builder transferAccountID(AccountID.Builder builder) {
            this.transferAccountID = builder.build();
            return this;
        }

        public Builder deleteAccountID(AccountID deleteAccountID) {
            this.deleteAccountID = deleteAccountID;
            return this;
        }

        public Builder deleteAccountID(AccountID.Builder builder) {
            this.deleteAccountID = builder.build();
            return this;
        }
    }
}

