/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.codec.GrantedCryptoAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.GrantedCryptoAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record GrantedCryptoAllowance(@Nullable AccountID spender, long amount) {
    public static final Codec<GrantedCryptoAllowance> PROTOBUF = new GrantedCryptoAllowanceProtoCodec();
    public static final JsonCodec<GrantedCryptoAllowance> JSON = new GrantedCryptoAllowanceJsonCodec();
    public static final GrantedCryptoAllowance DEFAULT = GrantedCryptoAllowance.newBuilder().build();

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.spender, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID spender = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(AccountID spender, long amount) {
            this.spender = spender;
            this.amount = amount;
        }

        public GrantedCryptoAllowance build() {
            return new GrantedCryptoAllowance(this.spender, this.amount);
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

