/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.GrantedNftAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.GrantedNftAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record GrantedNftAllowance(@Nullable TokenID tokenId, @Nullable AccountID spender) {
    public static final Codec<GrantedNftAllowance> PROTOBUF = new GrantedNftAllowanceProtoCodec();
    public static final JsonCodec<GrantedNftAllowance> JSON = new GrantedNftAllowanceJsonCodec();
    public static final GrantedNftAllowance DEFAULT = GrantedNftAllowance.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.spender);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID spender = null;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID spender) {
            this.tokenId = tokenId;
            this.spender = spender;
        }

        public GrantedNftAllowance build() {
            return new GrantedNftAllowance(this.tokenId, this.spender);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }
    }
}

