/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.GrantedTokenAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.GrantedTokenAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record GrantedTokenAllowance(@Nullable TokenID tokenId, @Nullable AccountID spender, long amount) {
    public static final Codec<GrantedTokenAllowance> PROTOBUF = new GrantedTokenAllowanceProtoCodec();
    public static final JsonCodec<GrantedTokenAllowance> JSON = new GrantedTokenAllowanceJsonCodec();
    public static final GrantedTokenAllowance DEFAULT = GrantedTokenAllowance.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.spender, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID spender = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID spender, long amount) {
            this.tokenId = tokenId;
            this.spender = spender;
            this.amount = amount;
        }

        public GrantedTokenAllowance build() {
            return new GrantedTokenAllowance(this.tokenId, this.spender, this.amount);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

