/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.NftAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.NftAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record NftAllowance(@Nullable TokenID tokenId, @Nullable AccountID owner, @Nullable AccountID spender, List<Long> serialNumbers, @Nullable Boolean approvedForAll, @Nullable AccountID delegatingSpender) {
    public static final Codec<NftAllowance> PROTOBUF = new NftAllowanceProtoCodec();
    public static final JsonCodec<NftAllowance> JSON = new NftAllowanceJsonCodec();
    public static final NftAllowance DEFAULT = NftAllowance.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public AccountID ownerOrElse(@NonNull AccountID defaultValue) {
        return this.hasOwner() ? this.owner : defaultValue;
    }

    @NonNull
    public AccountID ownerOrThrow() {
        return Objects.requireNonNull(this.owner, "Field owner is null");
    }

    public void ifOwner(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasOwner()) {
            ifPresent.accept(this.owner);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public boolean hasApprovedForAll() {
        return this.approvedForAll != null;
    }

    public Boolean approvedForAllOrElse(@NonNull Boolean defaultValue) {
        return this.hasApprovedForAll() ? this.approvedForAll : defaultValue;
    }

    @NonNull
    public Boolean approvedForAllOrThrow() {
        return Objects.requireNonNull(this.approvedForAll, "Field approvedForAll is null");
    }

    public void ifApprovedForAll(@NonNull Consumer<Boolean> ifPresent) {
        if (this.hasApprovedForAll()) {
            ifPresent.accept(this.approvedForAll);
        }
    }

    public boolean hasDelegatingSpender() {
        return this.delegatingSpender != null;
    }

    public AccountID delegatingSpenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasDelegatingSpender() ? this.delegatingSpender : defaultValue;
    }

    @NonNull
    public AccountID delegatingSpenderOrThrow() {
        return Objects.requireNonNull(this.delegatingSpender, "Field delegatingSpender is null");
    }

    public void ifDelegatingSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasDelegatingSpender()) {
            ifPresent.accept(this.delegatingSpender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.owner, this.spender, this.serialNumbers, this.approvedForAll, this.delegatingSpender);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID owner = null;
        private AccountID spender = null;
        private List<Long> serialNumbers = Collections.emptyList();
        private Boolean approvedForAll = null;
        private AccountID delegatingSpender = null;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID owner, AccountID spender, List<Long> serialNumbers, Boolean approvedForAll, AccountID delegatingSpender) {
            this.tokenId = tokenId;
            this.owner = owner;
            this.spender = spender;
            this.serialNumbers = serialNumbers;
            this.approvedForAll = approvedForAll;
            this.delegatingSpender = delegatingSpender;
        }

        public NftAllowance build() {
            return new NftAllowance(this.tokenId, this.owner, this.spender, this.serialNumbers, this.approvedForAll, this.delegatingSpender);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder owner(AccountID owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(AccountID.Builder builder) {
            this.owner = builder.build();
            return this;
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder serialNumbers(List<Long> serialNumbers) {
            this.serialNumbers = serialNumbers;
            return this;
        }

        public Builder serialNumbers(Long ... values) {
            this.serialNumbers = List.of(values);
            return this;
        }

        public Builder approvedForAll(Boolean approvedForAll) {
            this.approvedForAll = approvedForAll;
            return this;
        }

        public Builder delegatingSpender(AccountID delegatingSpender) {
            this.delegatingSpender = delegatingSpender;
            return this;
        }

        public Builder delegatingSpender(AccountID.Builder builder) {
            this.delegatingSpender = builder.build();
            return this;
        }
    }
}

