/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.NftRemoveAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.NftRemoveAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record NftRemoveAllowance(@Nullable TokenID tokenId, @Nullable AccountID owner, List<Long> serialNumbers) {
    public static final Codec<NftRemoveAllowance> PROTOBUF = new NftRemoveAllowanceProtoCodec();
    public static final JsonCodec<NftRemoveAllowance> JSON = new NftRemoveAllowanceJsonCodec();
    public static final NftRemoveAllowance DEFAULT = NftRemoveAllowance.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public AccountID ownerOrElse(@NonNull AccountID defaultValue) {
        return this.hasOwner() ? this.owner : defaultValue;
    }

    @NonNull
    public AccountID ownerOrThrow() {
        return Objects.requireNonNull(this.owner, "Field owner is null");
    }

    public void ifOwner(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasOwner()) {
            ifPresent.accept(this.owner);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.owner, this.serialNumbers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID owner = null;
        private List<Long> serialNumbers = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID owner, List<Long> serialNumbers) {
            this.tokenId = tokenId;
            this.owner = owner;
            this.serialNumbers = serialNumbers;
        }

        public NftRemoveAllowance build() {
            return new NftRemoveAllowance(this.tokenId, this.owner, this.serialNumbers);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder owner(AccountID owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(AccountID.Builder builder) {
            this.owner = builder.build();
            return this;
        }

        public Builder serialNumbers(List<Long> serialNumbers) {
            this.serialNumbers = serialNumbers;
            return this;
        }

        public Builder serialNumbers(Long ... values) {
            this.serialNumbers = List.of(values);
            return this;
        }
    }
}

