/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.codec.ProxyStakerJsonCodec;
import com.hedera.hapi.node.token.codec.ProxyStakerProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ProxyStaker(@Nullable AccountID accountID, long amount) {
    public static final Codec<ProxyStaker> PROTOBUF = new ProxyStakerProtoCodec();
    public static final JsonCodec<ProxyStaker> JSON = new ProxyStakerJsonCodec();
    public static final ProxyStaker DEFAULT = ProxyStaker.newBuilder().build();

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountID = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(AccountID accountID, long amount) {
            this.accountID = accountID;
            this.amount = amount;
        }

        public ProxyStaker build() {
            return new ProxyStaker(this.accountID, this.amount);
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

