/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.codec.TokenCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenCreateTransactionBodyProtoCodec;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenCreateTransactionBody(String name, String symbol, int decimals, long initialSupply, @Nullable AccountID treasury, @Nullable Key adminKey, @Nullable Key kycKey, @Nullable Key freezeKey, @Nullable Key wipeKey, @Nullable Key supplyKey, boolean freezeDefault, @Nullable Timestamp expiry, @Nullable AccountID autoRenewAccount, @Nullable Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, @Nullable Key feeScheduleKey, @Nullable List<CustomFee> customFees, @Nullable Key pauseKey) {
    public static final Codec<TokenCreateTransactionBody> PROTOBUF = new TokenCreateTransactionBodyProtoCodec();
    public static final JsonCodec<TokenCreateTransactionBody> JSON = new TokenCreateTransactionBodyJsonCodec();
    public static final TokenCreateTransactionBody DEFAULT = TokenCreateTransactionBody.newBuilder().build();

    public boolean hasTreasury() {
        return this.treasury != null;
    }

    public AccountID treasuryOrElse(@NonNull AccountID defaultValue) {
        return this.hasTreasury() ? this.treasury : defaultValue;
    }

    @NonNull
    public AccountID treasuryOrThrow() {
        return Objects.requireNonNull(this.treasury, "Field treasury is null");
    }

    public void ifTreasury(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTreasury()) {
            ifPresent.accept(this.treasury);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasKycKey() {
        return this.kycKey != null;
    }

    public Key kycKeyOrElse(@NonNull Key defaultValue) {
        return this.hasKycKey() ? this.kycKey : defaultValue;
    }

    @NonNull
    public Key kycKeyOrThrow() {
        return Objects.requireNonNull(this.kycKey, "Field kycKey is null");
    }

    public void ifKycKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKycKey()) {
            ifPresent.accept(this.kycKey);
        }
    }

    public boolean hasFreezeKey() {
        return this.freezeKey != null;
    }

    public Key freezeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFreezeKey() ? this.freezeKey : defaultValue;
    }

    @NonNull
    public Key freezeKeyOrThrow() {
        return Objects.requireNonNull(this.freezeKey, "Field freezeKey is null");
    }

    public void ifFreezeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFreezeKey()) {
            ifPresent.accept(this.freezeKey);
        }
    }

    public boolean hasWipeKey() {
        return this.wipeKey != null;
    }

    public Key wipeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasWipeKey() ? this.wipeKey : defaultValue;
    }

    @NonNull
    public Key wipeKeyOrThrow() {
        return Objects.requireNonNull(this.wipeKey, "Field wipeKey is null");
    }

    public void ifWipeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasWipeKey()) {
            ifPresent.accept(this.wipeKey);
        }
    }

    public boolean hasSupplyKey() {
        return this.supplyKey != null;
    }

    public Key supplyKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSupplyKey() ? this.supplyKey : defaultValue;
    }

    @NonNull
    public Key supplyKeyOrThrow() {
        return Objects.requireNonNull(this.supplyKey, "Field supplyKey is null");
    }

    public void ifSupplyKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSupplyKey()) {
            ifPresent.accept(this.supplyKey);
        }
    }

    public boolean hasExpiry() {
        return this.expiry != null;
    }

    public Timestamp expiryOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpiry() ? this.expiry : defaultValue;
    }

    @NonNull
    public Timestamp expiryOrThrow() {
        return Objects.requireNonNull(this.expiry, "Field expiry is null");
    }

    public void ifExpiry(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpiry()) {
            ifPresent.accept(this.expiry);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public boolean hasCustomFees() {
        return this.customFees != null;
    }

    public List<CustomFee> customFeesOrElse(@NonNull List<CustomFee> defaultValue) {
        return this.hasCustomFees() ? this.customFees : defaultValue;
    }

    @NonNull
    public List<CustomFee> customFeesOrThrow() {
        return Objects.requireNonNull(this.customFees, "Field customFees is null");
    }

    public void ifCustomFees(@NonNull Consumer<List<CustomFee>> ifPresent) {
        if (this.hasCustomFees()) {
            ifPresent.accept(this.customFees);
        }
    }

    public boolean hasPauseKey() {
        return this.pauseKey != null;
    }

    public Key pauseKeyOrElse(@NonNull Key defaultValue) {
        return this.hasPauseKey() ? this.pauseKey : defaultValue;
    }

    @NonNull
    public Key pauseKeyOrThrow() {
        return Objects.requireNonNull(this.pauseKey, "Field pauseKey is null");
    }

    public void ifPauseKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasPauseKey()) {
            ifPresent.accept(this.pauseKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.name, this.symbol, this.decimals, this.initialSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.freezeDefault, this.expiry, this.autoRenewAccount, this.autoRenewPeriod, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name = "";
        private String symbol = "";
        private int decimals = 0;
        private long initialSupply = 0L;
        private AccountID treasury = null;
        private Key adminKey = null;
        private Key kycKey = null;
        private Key freezeKey = null;
        private Key wipeKey = null;
        private Key supplyKey = null;
        private boolean freezeDefault = false;
        private Timestamp expiry = null;
        private AccountID autoRenewAccount = null;
        private Duration autoRenewPeriod = null;
        private String memo = "";
        private TokenType tokenType = TokenType.values()[0];
        private TokenSupplyType supplyType = TokenSupplyType.values()[0];
        private long maxSupply = 0L;
        private Key feeScheduleKey = null;
        private List<CustomFee> customFees = Collections.emptyList();
        private Key pauseKey = null;

        public Builder() {
        }

        public Builder(String name, String symbol, int decimals, long initialSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, boolean freezeDefault, Timestamp expiry, AccountID autoRenewAccount, Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey) {
            this.name = name;
            this.symbol = symbol;
            this.decimals = decimals;
            this.initialSupply = initialSupply;
            this.treasury = treasury;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.freezeDefault = freezeDefault;
            this.expiry = expiry;
            this.autoRenewAccount = autoRenewAccount;
            this.autoRenewPeriod = autoRenewPeriod;
            this.memo = memo;
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.maxSupply = maxSupply;
            this.feeScheduleKey = feeScheduleKey;
            this.customFees = customFees;
            this.pauseKey = pauseKey;
        }

        public TokenCreateTransactionBody build() {
            return new TokenCreateTransactionBody(this.name, this.symbol, this.decimals, this.initialSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.freezeDefault, this.expiry, this.autoRenewAccount, this.autoRenewPeriod, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder initialSupply(long initialSupply) {
            this.initialSupply = initialSupply;
            return this;
        }

        public Builder treasury(AccountID treasury) {
            this.treasury = treasury;
            return this;
        }

        public Builder treasury(AccountID.Builder builder) {
            this.treasury = builder.build();
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder kycKey(Key kycKey) {
            this.kycKey = kycKey;
            return this;
        }

        public Builder kycKey(Key.Builder builder) {
            this.kycKey = builder.build();
            return this;
        }

        public Builder freezeKey(Key freezeKey) {
            this.freezeKey = freezeKey;
            return this;
        }

        public Builder freezeKey(Key.Builder builder) {
            this.freezeKey = builder.build();
            return this;
        }

        public Builder wipeKey(Key wipeKey) {
            this.wipeKey = wipeKey;
            return this;
        }

        public Builder wipeKey(Key.Builder builder) {
            this.wipeKey = builder.build();
            return this;
        }

        public Builder supplyKey(Key supplyKey) {
            this.supplyKey = supplyKey;
            return this;
        }

        public Builder supplyKey(Key.Builder builder) {
            this.supplyKey = builder.build();
            return this;
        }

        public Builder freezeDefault(boolean freezeDefault) {
            this.freezeDefault = freezeDefault;
            return this;
        }

        public Builder expiry(Timestamp expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder expiry(Timestamp.Builder builder) {
            this.expiry = builder.build();
            return this;
        }

        public Builder autoRenewAccount(AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder supplyType(TokenSupplyType supplyType) {
            this.supplyType = supplyType;
            return this;
        }

        public Builder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public Builder feeScheduleKey(Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder customFees(List<CustomFee> customFees) {
            this.customFees = customFees;
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = List.of(values);
            return this;
        }

        public Builder pauseKey(Key pauseKey) {
            this.pauseKey = pauseKey;
            return this;
        }

        public Builder pauseKey(Key.Builder builder) {
            this.pauseKey = builder.build();
            return this;
        }
    }
}

