/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.token.AccountInfo;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AccountInfoJsonCodec
implements JsonCodec<AccountInfo> {
    @NonNull
    public AccountInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        AccountID temp_accountID = null;
        String temp_contractAccountID = "";
        boolean temp_deleted = false;
        AccountID temp_proxyAccountID = null;
        long temp_proxyReceived = 0L;
        Key temp_key = null;
        long temp_balance = 0L;
        long temp_generateSendRecordThreshold = 0L;
        long temp_generateReceiveRecordThreshold = 0L;
        boolean temp_receiverSigRequired = false;
        Timestamp temp_expirationTime = null;
        Duration temp_autoRenewPeriod = null;
        List temp_liveHashes = Collections.emptyList();
        List temp_tokenRelationships = Collections.emptyList();
        String temp_memo = "";
        long temp_ownedNfts = 0L;
        int temp_max_automatic_token_associations = 0;
        Bytes temp_alias = Bytes.EMPTY;
        Bytes temp_ledger_id = Bytes.EMPTY;
        long temp_ethereum_nonce = 0L;
        StakingInfo temp_staking_info = null;
        block46: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "accountID": {
                    temp_accountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
                case "contractAccountID": {
                    temp_contractAccountID = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block46;
                }
                case "deleted": {
                    temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "proxyAccountID": {
                    temp_proxyAccountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
                case "proxyReceived": {
                    temp_proxyReceived = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "key": {
                    temp_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
                case "balance": {
                    temp_balance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "generateSendRecordThreshold": {
                    temp_generateSendRecordThreshold = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "generateReceiveRecordThreshold": {
                    temp_generateReceiveRecordThreshold = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "receiverSigRequired": {
                    temp_receiverSigRequired = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "expirationTime": {
                    temp_expirationTime = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
                case "autoRenewPeriod": {
                    temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
                case "liveHashes": {
                    temp_liveHashes = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), LiveHash.JSON);
                    continue block46;
                }
                case "tokenRelationships": {
                    temp_tokenRelationships = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenRelationship.JSON);
                    continue block46;
                }
                case "memo": {
                    temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                    continue block46;
                }
                case "ownedNfts": {
                    temp_ownedNfts = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "maxAutomaticTokenAssociations": {
                    temp_max_automatic_token_associations = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "alias": {
                    temp_alias = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block46;
                }
                case "ledgerId": {
                    temp_ledger_id = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block46;
                }
                case "ethereumNonce": {
                    temp_ethereum_nonce = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block46;
                }
                case "stakingInfo": {
                    temp_staking_info = (StakingInfo)StakingInfo.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block46;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new AccountInfo(temp_accountID, temp_contractAccountID, temp_deleted, temp_proxyAccountID, temp_proxyReceived, temp_key, temp_balance, temp_generateSendRecordThreshold, temp_generateReceiveRecordThreshold, temp_receiverSigRequired, temp_expirationTime, temp_autoRenewPeriod, temp_liveHashes, temp_tokenRelationships, temp_memo, temp_ownedNfts, temp_max_automatic_token_associations, temp_alias, temp_ledger_id, temp_ethereum_nonce, temp_staking_info);
    }

    public String toJSON(@NonNull AccountInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.accountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountID", AccountID.JSON, (Object)data.accountID()));
        }
        if (data.contractAccountID() != "") {
            fieldLines.add(JsonTools.field((String)"contractAccountID", (String)data.contractAccountID()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.proxyAccountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"proxyAccountID", AccountID.JSON, (Object)data.proxyAccountID()));
        }
        if (data.proxyReceived() != 0L) {
            fieldLines.add(JsonTools.field((String)"proxyReceived", (long)data.proxyReceived()));
        }
        if (data.key() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"key", Key.JSON, (Object)data.key()));
        }
        if (data.balance() != 0L) {
            fieldLines.add(JsonTools.field((String)"balance", (long)data.balance()));
        }
        if (data.generateSendRecordThreshold() != 0L) {
            fieldLines.add(JsonTools.field((String)"generateSendRecordThreshold", (long)data.generateSendRecordThreshold()));
        }
        if (data.generateReceiveRecordThreshold() != 0L) {
            fieldLines.add(JsonTools.field((String)"generateReceiveRecordThreshold", (long)data.generateReceiveRecordThreshold()));
        }
        if (data.receiverSigRequired()) {
            fieldLines.add(JsonTools.field((String)"receiverSigRequired", (boolean)data.receiverSigRequired()));
        }
        if (data.expirationTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expirationTime", Timestamp.JSON, (Object)data.expirationTime()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (!data.liveHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"liveHashes", LiveHash.JSON, data.liveHashes()));
        }
        if (!data.tokenRelationships().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenRelationships", TokenRelationship.JSON, data.tokenRelationships()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.ownedNfts() != 0L) {
            fieldLines.add(JsonTools.field((String)"ownedNfts", (long)data.ownedNfts()));
        }
        if (data.maxAutomaticTokenAssociations() != 0) {
            fieldLines.add(JsonTools.field((String)"maxAutomaticTokenAssociations", (int)data.maxAutomaticTokenAssociations()));
        }
        if (data.alias() != Bytes.EMPTY && data.alias() != null && data.alias().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"alias", (Bytes)data.alias()));
        }
        if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
        }
        if (data.ethereumNonce() != 0L) {
            fieldLines.add(JsonTools.field((String)"ethereumNonce", (long)data.ethereumNonce()));
        }
        if (data.stakingInfo() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"stakingInfo", StakingInfo.JSON, (Object)data.stakingInfo()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

