/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.CryptoAllowance;
import com.hedera.hapi.node.token.schema.CryptoAllowanceSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class CryptoAllowanceProtoCodec
implements Codec<CryptoAllowance> {
    @NonNull
    public CryptoAllowance parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public CryptoAllowance parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull CryptoAllowance data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CryptoAllowanceSchema.OWNER, (Object)data.owner(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CryptoAllowanceSchema.SPENDER, (Object)data.spender(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)CryptoAllowanceSchema.AMOUNT, (long)data.amount());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(CryptoAllowance data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CryptoAllowanceSchema.OWNER, (Object)data.owner(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CryptoAllowanceSchema.SPENDER, (Object)data.spender(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)CryptoAllowanceSchema.AMOUNT, (long)data.amount());
    }

    public boolean fastEquals(@NonNull CryptoAllowance item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private CryptoAllowance parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        AccountID temp_owner = null;
        AccountID temp_spender = null;
        long temp_amount = 0L;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = CryptoAllowanceSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        AccountID value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_owner = value;
                        continue block7;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        AccountID value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_spender = value;
                        continue block7;
                    }
                    case 24: {
                        long value;
                        temp_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new CryptoAllowance(temp_owner, temp_spender, temp_amount);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new CryptoAllowance(temp_owner, temp_spender, temp_amount);
    }
}

