/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.token.schema.TokenMintTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TokenMintTransactionBodyProtoCodec
implements Codec<TokenMintTransactionBody> {
    @NonNull
    public TokenMintTransactionBody parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TokenMintTransactionBody parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TokenMintTransactionBody data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenMintTransactionBodySchema.TOKEN, (Object)data.token(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenMintTransactionBodySchema.AMOUNT, (long)data.amount());
        ProtoWriterTools.writeBytesList((WritableSequentialData)out, (FieldDefinition)TokenMintTransactionBodySchema.METADATA, data.metadata());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TokenMintTransactionBody data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenMintTransactionBodySchema.TOKEN, (Object)data.token(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenMintTransactionBodySchema.AMOUNT, (long)data.amount());
        return size += ProtoWriterTools.sizeOfBytesList((FieldDefinition)TokenMintTransactionBodySchema.METADATA, data.metadata());
    }

    public boolean fastEquals(@NonNull TokenMintTransactionBody item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TokenMintTransactionBody parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        TokenID temp_token = null;
        long temp_amount = 0L;
        List temp_metadata = Collections.emptyList();
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenMintTransactionBodySchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        TokenID value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_token = value;
                        continue block7;
                    }
                    case 16: {
                        long value;
                        temp_amount = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_metadata = ProtoParserTools.addToList(temp_metadata, (Object)value);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TokenMintTransactionBody(temp_token, temp_amount, temp_metadata);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TokenMintTransactionBody(temp_token, temp_amount, temp_metadata);
    }
}

