/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.transaction.codec.EntityIDJsonCodec;
import com.hedera.hapi.node.transaction.codec.EntityIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record EntityID(OneOf<EntityOneOfType> entity) {
    public static final Codec<EntityID> PROTOBUF = new EntityIDProtoCodec();
    public static final JsonCodec<EntityID> JSON = new EntityIDJsonCodec();
    public static final EntityID DEFAULT = EntityID.newBuilder().build();

    public EntityID {
        if (entity == null) {
            throw new NullPointerException("Parameter 'entity' must be supplied and can not be null");
        }
    }

    @Nullable
    public AccountID accountID() {
        return this.entity.kind() == EntityOneOfType.ACCOUNT_ID ? (AccountID)this.entity.value() : null;
    }

    public boolean hasAccountID() {
        return this.entity.kind() == EntityOneOfType.ACCOUNT_ID;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID() : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID(), "Field accountID is null");
    }

    @Nullable
    public LiveHash liveHash() {
        return this.entity.kind() == EntityOneOfType.LIVE_HASH ? (LiveHash)this.entity.value() : null;
    }

    public boolean hasLiveHash() {
        return this.entity.kind() == EntityOneOfType.LIVE_HASH;
    }

    public LiveHash liveHashOrElse(@NonNull LiveHash defaultValue) {
        return this.hasLiveHash() ? this.liveHash() : defaultValue;
    }

    @NonNull
    public LiveHash liveHashOrThrow() {
        return Objects.requireNonNull(this.liveHash(), "Field liveHash is null");
    }

    @Nullable
    public FileID fileID() {
        return this.entity.kind() == EntityOneOfType.FILE_ID ? (FileID)this.entity.value() : null;
    }

    public boolean hasFileID() {
        return this.entity.kind() == EntityOneOfType.FILE_ID;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID() : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID(), "Field fileID is null");
    }

    @Nullable
    public ContractID contractID() {
        return this.entity.kind() == EntityOneOfType.CONTRACT_ID ? (ContractID)this.entity.value() : null;
    }

    public boolean hasContractID() {
        return this.entity.kind() == EntityOneOfType.CONTRACT_ID;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID() : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID(), "Field contractID is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.entity);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum EntityOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        ACCOUNT_ID(1, "accountID"),
        LIVE_HASH(2, "liveHash"),
        FILE_ID(3, "fileID"),
        CONTRACT_ID(4, "contractID");

        private final int protoOrdinal;
        private final String protoName;

        private EntityOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static EntityOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> ACCOUNT_ID;
                case 2 -> LIVE_HASH;
                case 3 -> FILE_ID;
                case 4 -> CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static EntityOneOfType fromString(String name) {
            return switch (name) {
                case "ACCOUNT_ID", "accountID" -> ACCOUNT_ID;
                case "LIVE_HASH", "liveHash" -> LIVE_HASH;
                case "FILE_ID", "fileID" -> FILE_ID;
                case "CONTRACT_ID", "contractID" -> CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<EntityOneOfType> entity = EntityIDProtoCodec.ENTITY_UNSET;

        public Builder() {
        }

        public Builder(OneOf<EntityOneOfType> entity) {
            this.entity = entity;
        }

        public EntityID build() {
            return new EntityID(this.entity);
        }

        public Builder accountID(AccountID accountID) {
            this.entity = new OneOf((Object)EntityOneOfType.ACCOUNT_ID, (Object)accountID);
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.entity = new OneOf((Object)EntityOneOfType.ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder liveHash(LiveHash liveHash) {
            this.entity = new OneOf((Object)EntityOneOfType.LIVE_HASH, (Object)liveHash);
            return this;
        }

        public Builder liveHash(LiveHash.Builder builder) {
            this.entity = new OneOf((Object)EntityOneOfType.LIVE_HASH, (Object)builder.build());
            return this;
        }

        public Builder fileID(FileID fileID) {
            this.entity = new OneOf((Object)EntityOneOfType.FILE_ID, (Object)fileID);
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.entity = new OneOf((Object)EntityOneOfType.FILE_ID, (Object)builder.build());
            return this;
        }

        public Builder contractID(ContractID contractID) {
            this.entity = new OneOf((Object)EntityOneOfType.CONTRACT_ID, (Object)contractID);
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.entity = new OneOf((Object)EntityOneOfType.CONTRACT_ID, (Object)builder.build());
            return this;
        }
    }
}

